--  i := integer'value( s );
--  s := i'img;

With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure colorpicker is


procedure j_colorpicker(frame: integer; r,g,b: in out integer) is

    dialog,obj,rscroll,gscroll,bscroll,
    rlabel,glabel,blabel,panel1,panel2,canvas,
    ok,cancel                                  : integer;
    xpos,ypos                                  : integer;
    val                                        : String(1..255);
    
begin
    j_disable(frame);
 
    dialog := j_dialog(frame,"Colorpicker");
    j_setnamedcolorbg(dialog,J_WHITE);
    j_setborderlayout(dialog);
    panel1 := j_panel(dialog);
    j_setborderpos(panel1,J_LEFT);
    j_setborderlayout(panel1);

    panel2 := j_panel(panel1);
    j_setborderpos(panel2,J_TOP);
    j_setgridlayout(panel2,0,3);
    rlabel := j_label(panel2,"255");
    glabel := j_label(panel2,"255");
    blabel := j_label(panel2,"255");

    panel2 := j_panel(panel1);
    j_setgridlayout(panel2,0,3);
    j_sethgap(panel2,20);
    rscroll := j_vscrollbar(panel2);
    gscroll := j_vscrollbar(panel2);
    bscroll := j_vscrollbar(panel2);
    j_setmax(rscroll,265);
    j_setmax(gscroll,265);
    j_setmax(bscroll,265);
    j_setnamedcolorbg(rscroll,J_RED);
    j_setnamedcolorbg(gscroll,J_GREEN);
    j_setnamedcolorbg(bscroll,J_BLUE);
    j_setvalue(rscroll,r);
    j_setvalue(gscroll,g);
    j_setvalue(bscroll,b);

    panel1 := j_panel(dialog);
    j_setborderpos(panel1,J_BOTTOM);
    j_setflowlayout(panel1,J_HORIZONTAL);
    ok     := j_button(panel1,"   OK   ");
    cancel := j_button(panel1,"Cancel");

    canvas := j_canvas(dialog,200,200);

    j_pack(dialog);
    xpos := j_getxpos(frame) + ((j_getwidth(frame)-j_getwidth(dialog)) / 2);
    ypos := j_getypos(frame) + ((j_getheight(frame)-j_getheight(dialog)) / 2);
    j_setpos(dialog,xpos,ypos);
    j_show(dialog);
    
    obj:=0;
    while((obj /= cancel) and (obj /= dialog) and (obj /= ok)) loop
   
        j_setcolorbg(canvas,j_getvalue(rscroll),j_getvalue(gscroll),j_getvalue(bscroll));
        j_settext(rlabel,j_getvalue(rscroll)'img);
        j_settext(glabel,j_getvalue(gscroll)'img);
        j_settext(blabel,j_getvalue(bscroll)'img);

        obj :=  j_nextaction;

        if(obj = ok) then 
            r := j_getvalue(rscroll);
            g := j_getvalue(gscroll);
            b := j_getvalue(bscroll);
        end if;
    end loop;

    j_dispose(dialog);
    j_enable(frame);
    
end j_colorpicker;


    frame,menubar,jfile,color,quit,obj   : integer;
    r,g,b                                : integer;

begin    
    if( j_start = false ) then 
        Put_Line("cannot connect to JAPI Kernel");
        return;   
    end if;

    frame   := j_frame("Colorpicker Demo");
    menubar := j_menubar(frame);
    jfile   := j_menu(menubar,"File");
    color   := j_menuitem(jfile,"Color");
    quit    := j_menuitem(jfile,"Quit");

    r := 0; 
    g := 0;
    b := 0;
    j_setcolorbg(frame,r,g,b);
    j_show(frame);

    while obj/=frame and obj/=quit loop
    
        obj := j_nextaction;

        if(obj = color) then
            j_colorpicker(frame,r,g,b);
            j_setcolorbg(frame,r,g,b);
        end if;
           
    end loop;

    j_quit;
end colorpicker;