With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure cursor is

    frame,menubar,file,quit,obj               : integer;
    cursor,def,cross,hand,move,text,wait      : integer;
    resize,nr,ner,er,ser,sr,swr,wr,nwr         : integer;        

begin    
          
    if(not j_start) then
        put_line("cant connect to JAPI Kernel");
        return;
    end if;
	
    frame   := j_frame("Cursor Demo");
    menubar := j_menubar(frame);
    file   := j_menu(menubar,"File");
    quit    := j_menuitem(file,"Quit");

    cursor  := j_menu(menubar,"Cursor");
    def     := j_menuitem(cursor,"Default");
    cross   := j_menuitem(cursor,"Crosshair");
    text    := j_menuitem(cursor,"Text");
    wait    := j_menuitem(cursor,"Wait");
    hand    := j_menuitem(cursor,"Hand");
    move    := j_menuitem(cursor,"Move");

    resize  := j_menu(menubar,"Resize");
    nr      := j_menuitem(resize,"North Resize");
    ner     := j_menuitem(resize,"North East Resize");
    er      := j_menuitem(resize,"East Resize");
    ser     := j_menuitem(resize,"South East Resize");
    sr      := j_menuitem(resize,"South Resize");
    swr     := j_menuitem(resize,"South West Resize");
    wr      := j_menuitem(resize,"West Resize");
    nwr     := j_menuitem(resize,"North West Resize");
    
    
    j_show(frame);
    
    obj := 0;
    while obj/=frame and obj/=quit loop
        
        obj:=j_nextaction;
        
        if(obj=def) then
            j_setcursor(frame,J_DEFAULT_CURSOR);
        end if;
        if(obj=cross) then
            j_setcursor(frame,J_CROSSHAIR_CURSOR);
        end if;
        if(obj=hand) then
            j_setcursor(frame,J_HAND_CURSOR);
        end if;
        if(obj=move) then
            j_setcursor(frame,J_MOVE_CURSOR);
        end if;
        if(obj=text) then
            j_setcursor(frame,J_TEXT_CURSOR);
        end if;
        if(obj=wait) then
            j_setcursor(frame,J_WAIT_CURSOR);   
        end if;
        
        if(obj=nr) then
            j_setcursor(frame,J_N_RESIZE_CURSOR);
        end if;
        if(obj=ner) then
            j_setcursor(frame,J_NE_RESIZE_CURSOR);
        end if;
        if(obj=er) then
            j_setcursor(frame,J_E_RESIZE_CURSOR);
        end if;
        if(obj=ser) then
            j_setcursor(frame,J_SE_RESIZE_CURSOR);
        end if;
        if(obj=sr) then
            j_setcursor(frame,J_S_RESIZE_CURSOR);
        end if;
        if(obj=swr) then
            j_setcursor(frame,J_SW_RESIZE_CURSOR);
        end if;
        if(obj=wr) then
            j_setcursor(frame,J_W_RESIZE_CURSOR);
        end if;
        if(obj=nwr) then
            j_setcursor(frame,J_NW_RESIZE_CURSOR);
        end if;
        
    end loop;   
     
    j_quit;

end cursor;
