With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure drawables is

procedure drawgraphics(drawable,xmin,ymin,xmax,ymax : integer) is
   
    image,i,fntsize,x,y:integer;
    val    :  String(1..256);

begin
    fntsize:=10;
    
    j_setfontsize(drawable,fntsize);
    j_setnamedcolor(drawable,J_RED);

--  Drawings 
    j_drawline(drawable,xmin,ymin,xmax-1,ymax-1);
    j_drawline(drawable,xmin,ymax-1,xmax-1,ymin);
    j_drawrect(drawable,xmin,ymin,xmax-xmin-1,ymax-xmin-1);

    j_setnamedcolor(drawable,J_BLACK);
    j_drawline(drawable,xmin,ymax-30,xmax-1,ymax-30);
    j_drawstring(drawable,xmax/2-j_getstringwidth(drawable,xmax'img)/2,
                 ymax-40,xmax'img);

    j_drawline(drawable,xmin+30,ymin,xmin+30,ymax-1);
    j_drawstring(drawable,xmin+50,40,ymax'img);

    j_setnamedcolor(drawable,J_MAGENTA);
    for i in 1 .. 10 loop
    	j_drawoval(drawable,xmin+(xmax-xmin)/2,ymin+(ymax-ymin)/2,
                            (xmax-xmin)/20*i,(ymax-ymin)/20*i);
    end loop;
    
--  Text 
    j_setnamedcolor(drawable,J_BLUE);
    y:=ymin;
    for i in 5 .. 22 loop
	j_setfontsize(drawable,i);
	x := xmax-j_getstringwidth(drawable,"JAPI Test Text");
    	y := y+j_getfontheight(drawable);
    	j_drawstring(drawable,x,y,"JAPI Test Text");
    end loop;

--  Images 
    image := j_loadimage("images/twux.gif");
    if(image > 0) then
        j_drawimage(drawable,image,100,200);
        j_drawscaledimage(drawable,image,10,0,35,30,100,300,110,138);
    end if;
end;



frame,printer,canvas,image,obj,retval,
menubar,file,print,save,quit      : integer;

begin
    j_setdebug(4);

    if( j_start = false ) then 
        Put_Line("cannot connect to JAPI Kernel");
        return;   
    end if;
   
    frame   := j_frame("Drawables");
    j_setborderlayout(frame);

    menubar := j_menubar(frame);
    file    := j_menu(menubar,"File");
    print   := j_menuitem(file,"Print");
    save    := j_menuitem(file,"Save BMP");
    quit    := j_menuitem(file,"Quit");
    canvas  := j_canvas(frame,400,600);
    j_pack(frame);
    j_show(frame);

    drawgraphics(canvas,0,0,j_getwidth(canvas),j_getheight(canvas));
    obj:=0;
    while obj/=frame and obj/=quit loop
    
        obj := j_nextaction;

    	if(obj = canvas) then 
	    j_setnamedcolorbg(canvas,J_WHITE);
	    drawgraphics(canvas,10,10,j_getwidth(canvas)-10,j_getheight(canvas)-10);
	end if;

    	if(obj = print) then 
    	    printer := j_printer(frame);
    	    if(printer > 0 ) then 
	        drawgraphics(printer,40,40,j_getwidth(printer)-80,j_getheight(printer)-80);
	    	j_print(printer);
	    end if;	
    	end if;

    	if(obj = save) then 
--	    NOTE: sometimes problems with WinNT 24 Bit Colordepth (use 16 Bit) 
    	    image := j_image(600,800);
	    drawgraphics(image,0,0,600,800);
    	    if(not j_saveimage(image,"test.bmp",J_BMP)) then
	    	retval:=j_alertbox(frame,"Problems","Can't save image","OK");
	    end if;
     	end if;
    end loop;

    j_quit;
end drawables;


