With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure flowlayout is

    obj,frame,align,orient,fill,pack,
    alignment,orientation             : integer;
    dofill                            : boolean;

begin	

    alignment   := J_TOP;
    orientation := J_HORIZONTAL;
    dofill      := false;
    	
    if( j_start = false ) then 
        Put_Line("cannot connect to JAPI Kernel");
        return;   
    end if;

    frame   := j_frame("Flow Layout Demo");
    j_setsize(frame,800,600);

    j_setflowlayout(frame,orientation);
    j_setalign(frame,alignment);

    align   := j_button(frame,"alignment");
    orient  := j_button(frame,"orientation");
    fill    := j_button(frame,"fill");
    pack    := j_button(frame,"pack");

    j_sethgap(frame,10);
    j_setvgap(frame,10);


    j_setsize(align,100,100);
    j_setsize(orient,200,200);

    j_show(frame);

    obj:=0;
    while obj/=frame loop
        
        obj:=j_nextaction;
  	
        if(obj = align) then 
            case alignment is
                when J_LEFT        => alignment := J_CENTER;
                when J_CENTER      => alignment := J_RIGHT;
                when J_RIGHT       => alignment := J_TOP;
                when J_TOP         => alignment := J_BOTTOM;
                when J_BOTTOM      => alignment := J_TOPLEFT;
                when J_TOPLEFT     => alignment := J_TOPRIGHT;
                when J_TOPRIGHT    => alignment := J_BOTTOMLEFT;
                when J_BOTTOMLEFT  => alignment := J_BOTTOMRIGHT;
                when others        => alignment := J_LEFT;
            end case;
            j_setalign(frame,alignment);
        end if;

        if(obj = pack) then
            j_pack(frame);
        end if;
        
        if(obj = fill) then 
            if(dofill) then
            	dofill := false;
            else
            	dofill := true;
            end if;
            j_setflowfill(frame,dofill);
        end if;

        if(obj = orient) then 
            if(orientation = J_VERTICAL) then
            	orientation := J_HORIZONTAL;
            else
            	orientation := J_VERTICAL;
            end if;
            j_setflowlayout(frame,orientation);
            j_setalign(frame,alignment);
            j_setflowfill(frame,dofill);
        end if;
    
    end loop;
    
    j_quit;

end flowlayout;
