With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure insets is

    frame,menubar,file,   
    insets,obj,canvas,
    quit,plus,minus     : integer; 
    
begin
    j_setdebug(3);

    if( j_start = false ) then 
        Put_Line("cannot connect to JAPI Kernel");
        return;   
    end if;

    frame   := j_frame("Insets Demo");
    j_setborderlayout(frame);

    menubar := j_menubar(frame);
    file    := j_menu(menubar,"File");
    insets  := j_menu(menubar,"Insets");
    quit    := j_menuitem(file,"Quit");
    plus    := j_menuitem(insets,"Insets + 10");
    minus   := j_menuitem(insets,"Insets - 10");

    canvas  := j_canvas(frame,320,240);
    j_setnamedcolorbg(canvas,J_RED);

    j_pack(frame);
    j_show(frame);

    obj := 0;
    while((obj /= quit) and (obj /= frame)) loop      
    
        obj := j_nextaction;

        if(obj = canvas) then
	    j_setnamedcolorbg(canvas,J_RED);
        end if;
		
	if(obj = plus) then
            j_setinsets(frame,j_getinsets(frame,J_TOP)+10,j_getinsets(frame,J_BOTTOM)+10,
		              j_getinsets(frame,J_LEFT)+10,j_getinsets(frame,J_RIGHT)+10);
	end if;
	
	if(obj = minus) then
            j_setinsets(frame,j_getinsets(frame,J_TOP)-10,j_getinsets(frame,J_BOTTOM)-10,
		              j_getinsets(frame,J_LEFT)-10,j_getinsets(frame,J_RIGHT)-10);
        end if;
        
    end loop;
    
    j_quit;

end insets;
   