With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure mandel2 is

function mandel_iter(zre,zim:float; maxiter:integer) return integer is
    x,y,tmp,betrag  : float;
    iter,break      : integer;
begin
    x:=0.0;
    y:=0.0;
    iter:=0;
    betrag:=0.0;
    break:=0;
    
    while (iter < maxiter) and (break = 0) loop
        iter:= iter+1;
        tmp := x*x-y*y+zre;
        y := 2.0*x*y+zim;
        x := tmp;
        betrag := (x*x + y*y);
        if (betrag > 4.0) then 
           break := 1;
        end if;
    end loop;
    return(iter);
end mandel_iter;    


    x,y,do_work,it,
    frame,menubar,
    file,calc,
    quit,start,stop,
    canvas,obj,
    breite,hoehe            : integer;
    zre,zim                 : float;
    xstart,ystart,xend,yend : float;
    r,g,b                   : integer_array(0..4096);
begin
    
   
    do_work := 0;
    breite  := 325;
    hoehe   := 240;
        
--  mandelbrot area
    xstart := -1.8;
    xend   :=  0.8;
    ystart := -1.0;
    yend   :=  1.0;
    
    j_setdebug(3);
    
    if( j_start = false ) then 
        Put_Line("cannot connect to JAPI Kernel");
        return;   
    end if;
 
    
    frame   := j_frame("Mandelbrot");
    
    menubar := j_menubar(frame);
    file   := j_menu(menubar,"File");
    calc    := j_menu(menubar,"Calc");
    quit    := j_menuitem(file,"Quit");
    start   := j_menuitem(calc,"Start");
    stop    := j_menuitem(calc,"Stop ");
    j_show(frame);
     
    j_setborderlayout(frame);     
    canvas  := j_canvas(frame,breite,hoehe);    
 
    j_show(frame);
    j_pack(frame);
    
    x:=-1;
    y:=-1;
     obj:=0;
    do_work:=0;
    while obj/=quit loop
        if(do_work=1) then
            obj:=j_getaction;
        else
            obj:=j_nextaction;
        end if;
                
        if(obj = start) then 
            do_work := 1;
            x := -1;
            y := -1;
            j_setnamedcolorbg(canvas,J_WHITE);
        end if;
        
        if(obj = stop) then 
            do_work := 0;
        end if;
            
        if(do_work=1) then 
            y:=y+1;
            if(y = hoehe) then 
                y := 0;
                do_work := 0;
            else 
                for x in 0..breite loop
                    zre := xstart + float(x)*(xend-xstart)/float(breite);
                    zim := ystart + float(y)*(yend-ystart)/float(hoehe);
                    it   := mandel_iter(zre,zim,512);
                    r(x) := it*11;
                    g(x) := it*13;
                    b(x) := it*17;
                end loop;
                j_drawimagesource(canvas,0,y,breite,1,r,g,b);
            end if;
        end if;                
        
        if(obj=canvas) then
            breite := j_getwidth(canvas);
            hoehe  := j_getheight(canvas);
            x := -1;
            y := -1;
        end if;
        
   end loop;

    j_quit;

end mandel2;

