With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure menu is
frame,menubar,submenu,
file,edit,options,help,
open,save,quit,about,
cut,copy,paste,
enable,settings,obj  : integer;
inhalt               : String(1..255) ;
begin

    if(not j_start) then
	put_line("can't connect to JAPI Kernel \n");
	return;
    end if;
    
    frame    := j_frame("");

    menubar  := j_menubar(frame);
    file     := j_menu(menubar,"File");
    edit     := j_menu(menubar,"Edit");
    options  := j_menu(menubar,"Options");
    submenu  := j_menu(options,"Settings");
    help     := j_helpmenu(menubar,"Help");

    open     := j_menuitem(file,"Open");
    save     := j_menuitem(file,"Save");
    j_seperator(file);
    quit     := j_menuitem(file,"Quit");
    j_disable(save);
    j_setshortcut(quit,'q');

    cut      := j_menuitem(edit,"Cut");
    copy     := j_menuitem(edit,"Copy");
    paste    := j_menuitem(edit,"Paste");

    about    := j_menuitem(help,"About");

    enable   := j_checkmenuitem(submenu,"Enable Settings");
    settings := j_menuitem(submenu,"Settings");
    j_disable(settings);

    j_show(frame);

    obj:=0;
    while obj/=frame and obj/=quit loop
        
        obj:=j_nextaction;

        if(obj=enable) then
            if(not j_getstate(enable)) then
                j_disable(settings);
            else
                j_enable(settings);
            end if;
        end if;
        
        if(obj=cut) then
            if(j_gettext(cut,inhalt)="Cut") then
                j_settext(cut,"Ausschneiden");
            else
                j_settext(cut,"Cut");
            end if;
        end if;
        
        if(obj=copy) then
            if(j_gettext(copy,inhalt)="Copy") then
                j_settext(copy,"Kopieren");
            else
                j_settext(copy,"Copy");
            end if;
        end if;
        
        if(obj=paste) then
            if(j_gettext(paste,inhalt)="Paste") then
                j_settext(paste,"Einfuegen");
            else
                j_settext(paste,"Paste");
            end if;
        end if;
    
    end loop;
	
    j_quit;

end menu;
