With Gnat.IO; use Gnat.IO;
With japi; Use japi;

procedure  mouselistener is

    frame,obj,canvas1,canvas2,x,y,startx,starty   : integer;
    pressed,released,moved,dragged,entered,exited : integer;

begin    

    if( j_start = false ) then 
        Put_Line("cannot connect to JAPI Kernel");
        return;   
    end if;

    frame    := j_frame("move and drag the Mouse");
    j_setsize(frame,430,240);
    j_setnamedcolorbg(frame,J_LIGHT_GRAY);
    
    canvas1  := j_canvas(frame,200,200);
    canvas2  := j_canvas(frame,200,200);

    j_setpos(canvas1,10,30);
    j_setpos(canvas2,220,30);

    pressed  := j_mouselistener(canvas1,J_PRESSED);
    dragged  := j_mouselistener(canvas1,J_DRAGGED);
    released := j_mouselistener(canvas1,J_RELEASED);
    entered  := j_mouselistener(canvas2,J_ENTERERD);
    moved    := j_mouselistener(canvas2,J_MOVED);
    exited   := j_mouselistener(canvas2,J_EXITED);

    j_show(frame);

    obj:=0;
    while obj/=frame loop
        
        obj:=j_nextaction;
        
        if(obj = pressed) then 
            x:=j_getmousex(pressed);
            y:=j_getmousey(pressed);
            startx:=x;
            starty:=y;
        end if;
        
        if(obj = dragged) then 
            x:=j_getmousex(dragged);
            y:=j_getmousey(dragged);
            j_drawrect(canvas1,startx,starty,x-startx,y-starty);
        end if;
        
        if(obj = released) then 
            x:=j_getmousex(released);
            y:=j_getmousey(released);
            j_drawrect(canvas1,startx,starty,x-startx,y-starty);
        end if;

        if(obj = entered) then 
            x:=j_getmousex(entered);
            y:=j_getmousey(entered);
            startx:=x;
            starty:=y;
        end if;
 
        if(obj = moved) then 
            x:=j_getmousex(moved);
            y:=j_getmousey(moved);
            j_drawline(canvas2,startx,starty,x,y);
            startx:=x;
            starty:=y;
        end if;

        if(obj = exited) then 
            x:=j_getmousex(exited);
            y:=j_getmousey(exited);
            j_drawline(canvas2,startx,starty,x,y);
        end if;

    end loop;
    
    j_quit;
end mouselistener;
