With Gnat.IO; use Gnat.IO;
With Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
With japi; Use japi;

procedure text is

    frame,menubar,file,jnew,save,quit,obj : integer;
    edit,selall,cut,copy,paste             : integer;
    text,selstart,selend                   : integer;
    newtext                                : string(1..88);
    inhalt                                 : Unbounded_String;

begin    
    newtext := "JAPI (Java Application\nProgramming Interface)\na platform and language\nindependent API";
    
    
    if( j_start = false ) then 
        Put_Line("cannot connect to JAPI Kernel");
        return;   
    end if;
        
    frame   := j_frame("A simple editor");
    menubar := j_menubar(frame);
    file    := j_menu(menubar,"File");
    jnew    := j_menuitem(file,"New");
    save    := j_menuitem(file,"Save");
    j_seperator(file);
    quit    := j_menuitem(file,"Quit");

    edit    := j_menu(menubar,"Edit");
    selall  := j_menuitem(edit,"Select All");
    j_seperator(edit);
    cut     := j_menuitem(edit,"Cut");
    copy    := j_menuitem(edit,"Copy");
    paste   := j_menuitem(edit,"Paste");

    text    := j_textarea(frame,25,12);
    j_setpos(text,10,60);
    j_settext(text,newtext);

    j_show(frame);
    j_pack(frame);
        
    obj:=0;
    while obj/=quit and obj/=frame loop
     
        obj:=j_nextaction;   

        if(obj = text) then
            Put_Line("text changed length = " & j_getlength(text)'img);
        end if;

        if(obj = jnew) then
            j_settext(text,newtext);
        end if;

        if(obj = save) then 
            Put_Line(j_gettext(text,To_String(inhalt)));
        end if;

        if(obj = selall) then
            j_selectall(text);
        end if;

        if((obj = cut) or (obj = copy) or (obj = paste)) then
            selstart := j_getselstart(text);
            selend   := j_getselend(text);
        end if;
        
        if(obj = cut) then 
            j_delete(text,selstart,selend);
            j_selecttext(text,selstart,selstart);
        end if;
        
        if(obj = copy) then
            inhalt:=To_Unbounded_String(j_getseltext(text,To_String(inhalt)));
        end if;

        if(obj = paste) then 
            if(selstart = selend) then
                j_inserttext(text,To_String(inhalt),j_getcurpos(text));
            else
                j_replacetext(text,To_String(inhalt),selstart,selend);
            end if;
            j_setcurpos(text,selstart);
        end if;
  
    end loop;
     
    j_quit;
 
 end text;

