rem Example colorpicker.bas


SCRIBA    import japi.bas


    r=0
    g=0
    b=0
    j_setdebug(0)

    if( j_start() = J_FALSE ) then
        print "can't connect to JAPI server"   
        end
    endif

    jframe  = j_frame("Colorpicker Demo")
    menubar = j_menubar(jframe)
    jfile   = j_menu(menubar,"File")
    jcolor  = j_menuitem(jfile,"Color")
    quit    = j_menuitem(jfile,"Quit")

    j_setcolorbg(jframe,r,g,b)
    j_show(jframe)

    obj=0
    while((obj <> jframe) and (obj <> quit))
        obj =  j_nextaction()

        if(obj = jcolor) then
            if(j_colorpicker(jframe)=J_TRUE) then
               j_setcolorbg(jframe,r,g,b)
            endif
        endif
    wend
    j_quit()
        
        
YABASIC    sub j_colorpicker(jframe)     
SCRIBA    function j_colorpicker(jframe)
    j_disable(jframe)
        
    dialog = j_dialog(jframe,"Colorpicker")
    j_setnamedcolorbg(dialog,J_WHITE)
    j_setborderlayout(dialog)
    panel1=j_panel(dialog)
    j_setborderpos(panel1,J_LEFT)
    j_setborderlayout(panel1)

    panel2=j_panel(panel1)
    j_setborderpos(panel2,J_TOP)
    j_setgridlayout(panel2,0,3)
    rjlabel=j_label(panel2,"255")
    gjlabel=j_label(panel2,"255")
    bjlabel=j_label(panel2,"255")

    panel2=j_panel(panel1)
    j_setgridlayout(panel2,0,3)
    j_sethgap(panel2,20)
    rscroll=j_vscrollbar(panel2)
    gscroll=j_vscrollbar(panel2)
    bscroll=j_vscrollbar(panel2)
    j_setmax(rscroll,265)
    j_setmax(gscroll,265)
    j_setmax(bscroll,265)
    j_setnamedcolorbg(rscroll,J_RED)
    j_setnamedcolorbg(gscroll,J_GREEN)
    j_setnamedcolorbg(bscroll,J_BLUE)
    j_setvalue(rscroll,r)
    j_setvalue(gscroll,g)
    j_setvalue(bscroll,b)
    
    panel1=j_panel(dialog)
    j_setborderpos(panel1,J_BOTTOM)
    j_setflowlayout(panel1,J_HORIZONTAL)
    ok = j_button(panel1,".   OK   .")
    cancel = j_button(panel1,"Cancel")
    
    canvas=j_canvas(dialog,200,200)

    j_pack(dialog)
    xpos = j_getxpos(jframe) + j_getwidth(jframe)/2-j_getwidth(dialog)/2
    ypos = j_getypos(jframe) + j_getheight(jframe)/2-j_getheight(dialog)/2
    j_setpos(dialog,xpos,ypos)
    j_show(dialog)

    obj = 0
    retval = J_FALSE
    while ((obj <> cancel) and (obj <> dialog) and (obj <> ok))
        lr = j_getvalue(rscroll)
        lg = j_getvalue(gscroll)
        lb = j_getvalue(bscroll)
        
        j_setcolorbg(canvas,lr,lg,lb)
        instr$ = str$(lr)
        j_settext(rjlabel,instr$)
        instr$ = str$(lg)
        j_settext(gjlabel,instr$)
        instr$ = str$(lb)
        j_settext(bjlabel,instr$)

        obj = j_nextaction()

        if(obj=ok) then
            r = lr
            g = lg
            b = lb
            retval = J_TRUE 
        endif
    wend
    
    j_dispose(dialog)
    j_enable(jframe)

YABASIC    return retval
YABASIC    end sub
SCRIBA    j_colorpicker=retval
SCRIBA    end function