rem       Example font.bas

    SCRIBA    import japi.bas
    if( j_start() = J_FALSE ) then
       print "can't connect to JAPI server"   
       end
    endif

    jframe    = j_frame("Font Demo")
    menubar   = j_menubar(jframe)
    jfile     = j_menu(menubar,"File")
    quit      = j_menuitem(jfile,"Quit")


    font      = j_menu(menubar,"Font")
    courier   = j_menuitem(font,"Courier")
    helvetia  = j_menuitem(font,"Helvetia")
    times     = j_menuitem(font,"Times")
    dialogin  = j_menuitem(font,"DialogIn")
    dialogout = j_menuitem(font,"DialogOut")

    style     = j_menu(menubar,"Style")
    normal    = j_menuitem(style,"Plain")
    bold      = j_checkmenuitem(style,"Bold")
    italic    = j_checkmenuitem(style,"Italic")

    size      = j_menu(menubar,"Size")
    f10       = j_menuitem(size,"10 pt")
    f12       = j_menuitem(size,"12 pt")
    f14       = j_menuitem(size,"14 pt")
    f18       = j_menuitem(size,"18 pt")

    jlabel     = j_label(jframe,"abcdefghijklmnopqrstuvwxyz")
    j_setsize(jlabel,400,120)
    j_setpos(jlabel,5,60)

    fontstyle = J_PLAIN

    j_setfont(jframe,J_HELVETIA,J_PLAIN,12)

    j_pack(jframe)
    j_show(jframe)

    obj=0
    while((obj <> jframe) and (obj <> quit))
       obj=j_nextaction()
 
       if(obj = courier)  then
          j_setfontname(jlabel,J_COURIER)
       endif
       if(obj = helvetia) then
          j_setfontname(jlabel,J_HELVETIA)
       endif
       if(obj = times) then
          j_setfontname(jlabel,J_TIMES)
       endif
       if(obj = dialogin) then
          j_setfontname(jlabel,J_DIALOGIN)
       endif
       if(obj = dialogout) then
          j_setfontname(jlabel,J_DIALOGOUT)
       endif

       if(obj = normal) then
          fontstyle=J_PLAIN
          j_setstate(bold,J_FALSE)
          j_setstate(italic,J_FALSE)
          j_setfontstyle(jlabel,fontstyle)
       endif
    
       if(obj = bold) then
          if(j_getstate(bold)=J_TRUE)  then
             fontstyle = fontstyle + J_BOLD
          else
             fontstyle = fontstyle - J_BOLD
          endif
          j_setfontstyle(jlabel,fontstyle)
       endif
    
       if(obj = italic) then
          if(j_getstate(italic)=J_TRUE)  then
             fontstyle = fontstyle + J_ITALIC
          else
             fontstyle = fontstyle - J_ITALIC
          endif
          j_setfontstyle(jlabel,fontstyle)
       endif

       if(obj = f10) then
          j_setfontsize(jlabel,10)
       endif
       if(obj = f12) then
          j_setfontsize(jlabel,11)
       endif
       if(obj = f14) then
          j_setfontsize(jlabel,13)
       endif
       if(obj = f18) then
          j_setfontsize(jlabel,18)
       endif
       
YABASIC       instr$ = " StringWidth = "
YABASIC       instr$ = instr$ + str$(j_getstringwidth(jlabel,"abcdefghijklmnopqrstuvwxyz"))
YABASIC       instr$ = instr$ + " FontHeight = "+str$(j_getfontheight(jlabel))
YABASIC       instr$ = instr$ + " FontAscent = "+str$(j_getfontascent(jlabel))
SCRIBA       instr$ = " StringWidth = "
SCRIBA       instr$ = instr$ & str$(j_getstringwidth(jlabel,"abcdefghijklmnopqrstuvwxyz"))
SCRIBA       instr$ = instr$ & " FontHeight = " & str$(j_getfontheight(jlabel))
SCRIBA       instr$ = instr$ & " FontAscent = " & str$(j_getfontascent(jlabel))
       j_settext(jframe,instr$)

    wend
    j_quit()