rem Example mandel.bas

SCRIBAimport japi.bas

xstart = -1.8
xend   =  0.8
ystart = -1.0
yend   =  1.0

hoehe  = 240
breite = 320

if(j_start() = J_FALSE) then
    print("can't connect to JAPI server")
    end
endif

jframe  = j_frame("Variables Mandelbrot")
j_setborderlayout(jframe)

menubar = j_menubar(jframe)
jfile   = j_menu(menubar,"File")
calc    = j_menu(menubar,"Calc")
quit    = j_menuitem(jfile,"Quit")
start   = j_menuitem(calc,"Start")
jstop   = j_menuitem(calc,"Stop")

canvas  = j_canvas(jframe,breite,hoehe)

j_pack(jframe)
j_show(jframe)

obj = 0
do_work = 0

while((obj <> jframe) and (obj <> quit))

    if(do_work = 1) then
        obj = j_getaction()
    else
        obj = j_nextaction()
    endif      

    if(obj = start) then
        x = -1
        y = -1
        do_work = 1
    endif

    if(obj = jstop) then
       do_work = 0
    endif
    
    if(do_work = 1) then
YABASIC        x = mod(x+1,breite)
SCRIBA        x = (x+1) % breite
        if(x = 0) then
YABASIC            y = mod(y+1,hoehe)
SCRIBA            y = (y+1) % hoehe
        endif
        if((x = breite-1) and (y = hoehe-1)) then
            do_work = 0
        else
            zre = xstart + x*(xend-xstart)/breite
            zim = ystart + y*(yend-ystart)/hoehe
            it = mandel(zre,zim,512)
            j_setcolor(canvas,it*11,it*13,it*17)
            j_drawpixel(canvas,x,y)
        endif
    endif

    if(obj = canvas) then
        breite = j_getwidth(canvas)
        hoehe = j_getheight(canvas)
        x=-1
        y=-1
    endif
wend
j_quit()



YABASICsub mandel(zre,zim,maxiter)
SCRIBAfunction mandel(zre,zim,maxiter)
    mx = 0.0
    my = 0.0
    iter=0
    betrag=0.0
 
    while ((iter < maxiter) and (betrag < 4.0))
        iter = iter+1
        tmp = mx*mx-my*my+zre
        my = 2*mx*my+zim
        mx = tmp
        betrag = (mx*mx + my*my)
    wend
YABASIC    return iter
YABASICend sub    
SCRIBA    mandel=iter
SCRIBAend function
