rem       Example mandel2.bas 

SCRIBAimport japi.bas
    
breite = 320
hoehe  = 240 
        
lxs = -1.8
lxe =  0.8
lys = -1.0
lye =  1.0

YABASICdim r(4096)
YABASICdim g(4096)
YABASICdim b(4096)

j_setdebug(3)

if( j_start() = J_FALSE ) then
    print "can't connect to server"   
    end
endif

jframe   = j_frame("Mandelbrot") 
j_setborderlayout(jframe)
        
menubar = j_menubar(jframe)
jfile   = j_menu(menubar,"File")
calc    = j_menu(menubar,"Calc")
jprint  = j_menuitem(jfile,"Print")
quit    = j_menuitem(jfile,"Quit")
start   = j_menuitem(calc,"Start")
jstop   = j_menuitem(calc,"Stop")
jreset  = j_menuitem(calc,"Reset")

canvas  = j_canvas(jframe,breite,hoehe)

pressed  = j_mouselistener(canvas,J_PRESSED)
dragged  = j_mouselistener(canvas,J_DRAGGED)

j_pack(jframe)
j_show(jframe)

x=-1
y=-1
do_work = J_FALSE
obj = 0
while((obj <> jframe) and (obj <> quit))
        
    if(do_work = J_TRUE) then
        obj=j_getaction()
    else
        obj=j_nextaction()
    endif
                       
    if(obj=start) then
   	xstart = lxs
    	xend   = lxe
    	ystart = lys
    	yend   = lye
        x=-1
        y=-1
        do_work = J_TRUE
        j_setnamedcolorbg(canvas,J_WHITE)
    endif

    if(obj=jstop) then
       do_work = J_FALSE
    endif
                
    if(obj=jprint) then
       j_print(canvas)
    endif
           
    if(obj=canvas) then
        breite = j_getwidth(canvas)
        hoehe  = j_getheight(canvas)
        x=-1
        y=-1
        j_setnamedcolorbg(canvas,J_WHITE)
    endif
    
    if(obj=jreset) then
        lxs = -1.8
        lxe =  0.8
        lys = -1.0
        lye =  1.0
        xstart = -1.8
        xend   =  0.8
        ystart = -1.0
        yend   =  1.0
        x=-1
        y=-1
        j_setnamedcolorbg(canvas,J_WHITE)
    endif
    
    if(do_work = J_TRUE) then
        y=y+1
        if(y = hoehe) then
            y = 0
            do_work = J_FALSE
        else
            for x=0 to breite 
               zre = xstart + x*(xend-xstart)/breite
               zim = ystart + y*(yend-ystart)/hoehe
               it = mandel(zre,zim,512)
YABASIC               r(x)=it*11
YABASIC               g(x)=it*13
YABASIC               b(x)=it*17
SCRIBA               r[x]=it*11
SCRIBA               g[x]=it*13
SCRIBA               b[x]=it*17
            next x
YABASIC            j_drawimagesource(canvas,0,y,breite,1,r(),g(),b())
SCRIBA            j_drawimagesource(canvas,0,y,breite,1,r,g,b)
        endif
    endif                                

    if(obj=pressed) then
        j_setxor(canvas,J_TRUE)
        j_setnamedcolor(canvas,J_BLACK)
        j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys)
        mxe=j_getmousex(pressed)
        mye=j_getmousey(pressed)
        mxs=mxe
        mys=mye
    endif

    if(obj=dragged) then
        j_setxor(canvas,J_TRUE)
        j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys)
        mxe=j_getmousex(dragged)
        mye=j_getmousey(dragged)
        j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys)
        j_setxor(canvas,J_FALSE)
        lxs = xstart+(xend-xstart)*mxs/breite
        lxe = xstart+(xend-xstart)*mxe/breite
        lys = ystart+(yend-ystart)*mys/hoehe
        lye = ystart+(yend-ystart)*mye/hoehe
    endif

wend      
j_quit()        


YABASICsub mandel(zre,zim,maxiter)
SCRIBAfunction mandel(zre,zim,maxiter)
    mx = 0.0
    my = 0.0
    iter=0
    betrag=0.0
 
    while ((iter < maxiter) and (betrag < 4.0))
        iter = iter+1
        tmp = mx*mx-my*my+zre
        my = 2*mx*my+zim
        mx = tmp
        betrag = (mx*mx + my*my)
    wend
YABASIC    return iter
YABASICend sub    
SCRIBA    mandel=iter
SCRIBAend function
