#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "parsejapi.h"
#define WARNING   "  generated by makejapif   DO NOT EDIT"

char* upstr(char* ptr)
{
	int i;
	for(i=0;i<strlen(ptr);i++)
		ptr[i]=toupper(ptr[i]);
	return(ptr);
}

int main(int argc, char *argv[])
{

	FILE* fd;
	char cmd[256],line[256],fname[256],*fnameptr;
	int i,n,argtype,tab=20,islahey=0,isfps=0;

	if(argc > 1)
	{
		if(strcasecmp(argv[1],"-lahey")==0)
			islahey=1;
	}

	if(argc > 1)
	{
		if(strcasecmp(argv[1],"-fps")==0)
			isfps=1;
	}

	if((fd=fopen("./japilib.c","r"))==NULL)
		perror("kann Datei './japilib.c' nicht oeffnen!"),exit(-1);
	fclose(fd);

	sprintf(cmd,"cat ./japilib.c | sed s/\\(/' \\( '/g | sed s/\\)/' \\) '/g | sed s/','/' , '/g > /tmp/.japilib.c");
	system(cmd);
	if((fd=fopen("/tmp/.japilib.c","r"))==NULL)
		perror("kann Datei '/tmp/.japilib.c' nicht oeffnen!"),exit(-1);
	fclose(fd);

	if(isfps)
	{
//	    printf("$FREEFORM\n\n");
		printf("\n\nC\nC\nC ");
		printf("  JAPI Include for Microsoft Fortran Powerstation 4\n");
	}
	if(islahey)
	{
		printf("\n\nC\nC\nC ");
		printf("  JAPI Include for Lahey Fortran 90 Compiler\n");
	}

	// Warning
	printf("C\nC\nC\nC\nC ");
	printf(WARNING);
	printf("\nC\nC   ");
//	fflush(stdout);
//	system("date");
	printf("C\nC\n");

	// Defines
	if((fd=fopen("./japiconst.def","r"))==NULL)
		perror("cant open 'japiconst.def' !"),exit(-1);

	while(fscanf(fd,"%s",cmd)!=EOF)
	{
		if(strcasecmp(cmd,"TYPE")==0)
		{
			printf("        PARAMETER ");
			fscanf(fd,"%s",cmd);
			printf("( %s",cmd);
			for(i=strlen(cmd);i<tab;i++)
				printf(" ");
/*
			if(strstr(cmd,"J_TRUE")!=NULL)
				printf("= .true.)\n");
			else if(strstr(cmd,"J_FALSE")!=NULL)
				printf("= .false.)\n");
			else
*/
			{
				fscanf(fd,"%s",cmd);
				printf("=    %s)\n",cmd);
			}
		}
		else if(strcasecmp(cmd,"COMMENT")==0)
		{
			fscanf(fd,"%s",cmd);
			printf("\n\n\nC      %s\n",cmd);
		}
	}
	fclose(fd);
	printf("\n\n\n\n");


	// LAHEY : DLL_IMPORT
	if(islahey)
	{
		if((fd=fopen("/tmp/.japilib.c","r"))==NULL)
			perror("cant open '/tmp/.japilib.c' !"),exit(-1);

		while(readline(fd,line)!=EOF)
			if(isjapifunc(line))
				printf("        DLL_IMPORT j%s\n",funcname(line,fname));

		printf("\n\n\n");
		fclose(fd);
	}

	if((fd=fopen("/tmp/.japilib.c","r"))==NULL)
		perror("kcant open '/tmp/.japilib.c' !"),exit(-1);

	// INTERFACE for Fortran Power Station
	if(isfps)
	{
		printf("        INTERFACE\n\n");
		while(readline(fd,line)!=EOF)
		{
			if(isjapifunc(line))
			{
				fnameptr=funcname(line,fname);
				switch(functype(line))
				{
					case(INT):		printf("          INTEGER FUNCTION ");
									break;
					case(CHAR):		printf("          CHARACTER FUNCTION ");
									break;
//					case(STRING):	printf("        ");
//									break;
					case(BOOL):	    printf("          LOGICAL FUNCTION ");
									break;
					default:        printf("          SUBROUTINE ");
				}
				printf("j%s",fnameptr);
				if(hasnargs(line)>0)
				{
					printf("(a0");
					for(i=1;i<hasnargs(line);i++)
						printf(",a%d",i);
					printf(")");
				}
		//		printf("\n            !MS$ATTRIBUTES STDCALL");
		//		printf(", ALIAS:'_j%s_'::",fnameptr);
		//		printf("J%s",upstr(fnameptr));
				printf("\n");
				n=0;
				switch(firstargtype(line))
				{
					case(INT):
					case(VARINT):		printf("            INTEGER a%d\n",n++);
										break;
					case(INTARR):
					case(VARINTARR): 	printf("            INTEGER a%d(*)\n",n++);
										break;
					case(CHAR):  	   	printf("            CHARACTER a%d\n",n++);
										break;
					case(STRING):
					case(RETSTR):  	   	printf("            CHARACTER*(*) a%d\n",n++);
										break;
					case(BOOL):  	   	printf("            LOGICAL a%d\n",n++);
										break;
				}

				while((argtype=nextargtype())!=NONE)
				{
					switch(argtype)
					{
						case(INT):
						case(VARINT):		printf("            INTEGER a%d\n",n++);
											break;
						case(INTARR):
						case(VARINTARR): 	printf("            INTEGER a%d(*)\n",n++);
											break;
						case(CHAR):  	   	printf("            CHARACTER a%d\n",n++);
											break;
						case(STRING):
						case(RETSTR):  	   	printf("            CHARACTER*(*) a%d\n",n++);
											break;
						case(BOOL):  	   	printf("            LOGICAL a%d\n",n++);
											break;
					}
				}

				switch(functype(line))
				{
					case(INT):
					case(CHAR):
//					case(STRING):
					case(BOOL):	    printf("          END FUNCTION\n\n");
									break;
					default:        printf("          END SUBROUTINE\n\n");
				}
			}
		}
		printf("\n        END INTERFACE\n\n");

	}
	else
	{
	// Gnu, Lahey.... typdefinition
		while(readline(fd,line)!=EOF)
		{
			if(isjapifunc(line))
			{
				switch(functype(line))
				{
					case(INT):		printf("        integer       ");
									break;
					case(CHAR):		printf("        character     ");
									break;
//					case(STRING):	printf("        character*(*) ");
//									break;
					case(BOOL):	    printf("        logical       ");
									break;
				}
				if((functype(line) != VOID) && (functype(line) != STRING))
					printf("j%s \n",funcname(line,fname));
			}
		}
	}
	printf("\n\n\n");
	fclose(fd);

	return(0);
}