#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "parsejapi.h"

static char* parseptr = NULL;




/*
 * liest von fd eine Zeile (bis '\n')
 */
int readline(FILE* fd, char *s)
{
	int t;
	while((t=(char)getc(fd))!='\n')
	{
		if(t == EOF)
			return(EOF);
		(*s)=(char)t;
		s++;
	}
	*s='\0';
	return(0);
}




/*
 * prueft, ob line eine funktionsdeklaration aus der japilib ist
 */
int isjapifunc(char* line)
{
	if((strstr(line,"int ")   !=NULL) ||
	   (strstr(line,"void ")  !=NULL) ||
	   (strstr(line,"char ")  !=NULL) ||
	   (strstr(line,"string ")!=NULL) ||
	   (strstr(line,"bool ")  !=NULL))
		   if(strstr(line,"japi_")!=NULL)
			   return(1);
	return(0);
}




/*
 * liefert die Anzahl der Funktionsargumente zurueck
 */
int hasnargs(char* line)
{
	char* ptr=line;
	int retval=0;

	if(!isjapifunc(line))
		return(-1);
	if((ptr = strstr(line,"("))==NULL)
		return(-1);

	if((strstr(ptr,"int")!=NULL) ||
	   (strstr(ptr,"bool")!=NULL) ||
	   (strstr(ptr,"string")!=NULL) ||
	   (strstr(ptr,"retstr")!=NULL))
	retval++;

	while((ptr = strstr(ptr,","))!=NULL)
	{
	    ptr++;
		retval++;
	}

	return(retval);
}




/*
 * liefert den Funktionstype zurueck
 */
int functype(char* line)
{
	char str[256];

	if(!isjapifunc(line))
		return(-1);

	if(sscanf(line,"%s",str) < 1)
		return(-1);

	if(strcasecmp(str,"string") == 0)
		return(STRING);
	if(strcasecmp(str,"void") == 0)
		return(VOID);
	if(strcasecmp(str,"int") == 0)
		return(INT);
	if(strcasecmp(str,"bool") == 0)
		return(BOOL);
	if(strcasecmp(str,"char") == 0)
		return(CHAR);
	if(strcasecmp(str,")") == 0)
		return(NONE);
	return(UNKNOWN);
}


/*
 * liefert den Funktionsnamen zurueck (ohne 'japi' Prefix)
 */
char* funcname(char* line, char* target)
{
	char* ptr=line;
	char* retptr=NULL;

	if(!isjapifunc(line))
		return(NULL);

	while(sscanf(ptr,"%s",target)==1)
	{
		if((retptr=strstr(target,"japi_"))!=NULL)
			return(target+4);
		ptr += strlen(target)+1;
	}

	return(NULL);
}




/*
 * liefert den Typ des ersten Arguments
 */
int firstargtype(char* line)
{
	char str[256];

	if(!isjapifunc(line))
		return(-1);

	if((parseptr = strstr(line,"("))==NULL)
		return(-1);

	parseptr++;
	if(sscanf(parseptr,"%s",str) < 1)
		return(-1);
	if(strcasecmp(str,"retstr") == 0)
		return(RETSTR);
	if(strcasecmp(str,"string") == 0)
		return(STRING);
	if(strcasecmp(str,"int") == 0)
		return(INT);
	if(strcasecmp(str,"varint") == 0)
		return(VARINT);
	if(strcasecmp(str,"intarr") == 0)
		return(INTARR);
	if(strcasecmp(str,"varintarr") == 0)
		return(VARINTARR);
	if(strcasecmp(str,"bool") == 0)
		return(BOOL);
	if(strcasecmp(str,"char") == 0)
		return(CHAR);
        if(strcasecmp(str,")") == 0)
		return(NONE);
	return(UNKNOWN);
}




/*
 * liefert den Typ des naechsten Arguments
 * zuvor muss firstargtype(char* line) aufgerufen worden sein
 */
int nextargtype()
{
	char str[256];

	if((parseptr = strstr(parseptr,","))==NULL)
		return(NONE);

	parseptr++;
	if(sscanf(parseptr,"%s",str) < 1)
		return(-1);
	if(strcasecmp(str,"retstr") == 0)
		return(RETSTR);
	if(strcasecmp(str,"string") == 0)
		return(STRING);
	if(strcasecmp(str,"int") == 0)
		return(INT);
	if(strcasecmp(str,"varint") == 0)
		return(VARINT);
	if(strcasecmp(str,"intarr") == 0)
		return(INTARR);
	if(strcasecmp(str,"varintarr") == 0)
		return(VARINTARR);
	if(strcasecmp(str,"bool") == 0)
		return(BOOL);
	if(strcasecmp(str,"char") == 0)
		return(CHAR);
        if(strcasecmp(str,")") == 0)
		return(NONE);
	return(UNKNOWN);
}

char* toupperstr(char* str)
{
    int i;
    for(i=0;i<strlen(str);i++)
        str[i]=toupper(str[i]);
    return(str);
}

char* tolowerstr(char* str)
{
    int i;
    for(i=0;i<strlen(str);i++)
        str[i]=tolower(str[i]);
    return(str);
}

void print_warning(char* warning)
{
	time_t ltime;
    time( &ltime );

	printf("\n\n/*\n\n ");
	printf("%s",warning);
	printf("\n\n   ");
	printf("   %s \n",ctime( &ltime ));
	printf("\n");
	printf(" */\n\n");
}

/*
	char* ptr=line;

	while(sscanf(ptr,"%s",str)==1)
	{
		printf("%s\n",str);
		ptr += strlen(str)+1;
	}
*/