#include <stdio.h>
#include "japi.h"


int j_colorpicker(int frame, unsigned char *r, unsigned char *g, unsigned char *b)
{
    int dialog,obj=0;
    int rscroll,gscroll,bscroll;
    int rlabel,glabel,blabel;
    int panel1,panel2,canvas;
    int ok,cancel;
    unsigned char str[256];
    int retval=J_FALSE;

    j_disable(frame);

    dialog = j_dialog(frame,"Colorpicker");
    j_setinsets(dialog,30,10,10,10);
    j_setnamedcolorbg(dialog,J_WHITE);
    j_setborderlayout(dialog);
    panel1=j_panel(dialog);
    j_setborderpos(panel1,J_LEFT);
    j_setborderlayout(panel1);

    panel2=j_panel(panel1);
    j_setborderpos(panel2,J_TOP);
    j_setgridlayout(panel2,0,3);
    rlabel=j_label(panel2,"255");
    glabel=j_label(panel2,"255");
    blabel=j_label(panel2,"255");

    panel2=j_panel(panel1);
    j_setgridlayout(panel2,0,3);
    j_sethgap(panel2,20);
    j_setinsets(panel1,0,0,0,10);
    rscroll=j_vscrollbar(panel2);
    gscroll=j_vscrollbar(panel2);
    bscroll=j_vscrollbar(panel2);
    j_setmax(rscroll,265);
    j_setmax(gscroll,265);
    j_setmax(bscroll,265);
    j_setnamedcolorbg(rscroll,J_RED);
    j_setnamedcolorbg(gscroll,J_GREEN);
    j_setnamedcolorbg(bscroll,J_BLUE);
    j_setvalue(rscroll,255- *r);
    j_setvalue(gscroll,255- *g);
    j_setvalue(bscroll,255- *b);

    panel1=j_panel(dialog);
    j_setborderpos(panel1,J_BOTTOM);
    j_setflowlayout(panel1,J_HORIZONTAL);
    ok = j_button(panel1,"   OK   ");
    cancel = j_button(panel1,"Cancel");
    j_setinsets(panel1,10,0,0,0);

    canvas=j_canvas(dialog,200,200);

    j_pack(dialog);
    j_setpos(dialog,j_getxpos(frame)+j_getwidth(frame)/2-j_getwidth(dialog)/2,
                    j_getypos(frame)+j_getheight(frame)/2-j_getheight(dialog)/2);
    j_show(dialog);

    while((obj!=cancel) && (obj != dialog))
    {
        j_setcolorbg(canvas,255-(char)(j_getvalue(rscroll)),
                            255-(char)(j_getvalue(gscroll)),
                            255-(char)(j_getvalue(bscroll)));
        sprintf(str,"%3d",255-j_getvalue(rscroll));
        j_settext(rlabel,str);
        sprintf(str,"%3d",255-j_getvalue(gscroll));
        j_settext(glabel,str);
        sprintf(str,"%3d",255-j_getvalue(bscroll));
        j_settext(blabel,str);

        obj =  j_nextaction();

        if(obj==ok)
        {
            retval=J_TRUE;
            *r = 255-j_getvalue(rscroll);
            *g = 255-j_getvalue(gscroll);
            *b = 255-j_getvalue(bscroll);
            break;
        }
    }

    j_dispose(dialog);
    j_enable(frame);
    return(retval);
}


int main()
{
    int frame,menubar,file,color,quit,obj;
    char r,g,b;

    j_setdebug(0);

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    frame   = j_frame("Colorpicker Demo");
    menubar = j_menubar(frame);
    file    = j_menu(menubar,"File");
    color   = j_menuitem(file,"Color");
    quit    = j_menuitem(file,"Quit");

    r=g=b=0;
    j_setcolorbg(frame,r,g,b);
    j_show(frame);

    while(1)
    {
        obj =  j_nextaction();

        if(obj==color)
            if(j_colorpicker(frame,&r,&g,&b)==J_TRUE)
                j_setcolorbg(frame,r,g,b);

        if((obj==quit) || (obj == frame))
            break;
    }

    j_quit();
    exit(0);
}


