#include <stdio.h>
#include "japi.h"

int main()
{
    int frame,obj,resized,moved,hidden,shown;
    int text;
	char str[256];

    j_setdebug(3);

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphical Objects */
    frame   = j_frame("Component Listener");
    j_setgridlayout(frame,1,1);

    text    = j_textarea(frame,80,25);
printf("%d\n",text);

	resized = j_componentlistener(text,J_RESIZED);
	moved   = j_componentlistener(frame,J_MOVED);
	hidden  = j_componentlistener(text,J_HIDDEN);
	shown   = j_componentlistener(text,J_SHOWN);

    j_show(frame);
	j_pack(frame);


    while((obj=j_nextaction())!=frame)
    {
		if(obj==resized)
		{
			sprintf(str,"resized to %d rows %d columns\n",j_getrows(text),j_getcolumns(text));
			j_appendtext(text,str);
		}

		if(obj==moved)
		{
			j_appendtext(text,"Frame moved\n");
			if(j_isvisible(text))
			{
				j_settext(frame,"Move again to see the text!");
				j_hide(text);
			}
			else
			{
				j_settext(frame,"Component Listener");
				j_show(text);
			}
		}

		if(obj==hidden)
			j_appendtext(text,"Text hidden\n");

		if(obj==shown)
			j_appendtext(text,"Text shown\n");

    }
	j_quit();
	
    exit(0);
}


