#include <stdio.h>
#include "japi.h"

void drawgraphics(int drawable,int xmin,int ymin,int xmax,int ymax)
{
    int image,i,fntsize=10,x,y;
    char tmpstr[256];

    j_setfontsize(drawable,fntsize);
    j_setnamedcolor(drawable,J_RED);

	/* Drawings */
    j_drawline(drawable,xmin,ymin,xmax-1,ymax-1);
    j_drawline(drawable,xmin,ymax-1,xmax-1,ymin);
    j_drawrect(drawable,xmin,ymin,xmax-xmin-1,ymax-xmin-1);

    j_setnamedcolor(drawable,J_BLACK);
    j_drawline(drawable,xmin,ymax-30,xmax-1,ymax-30);
    sprintf(tmpstr,"XMax = %d",xmax);
    j_drawstring(drawable,xmax/2-j_getstringwidth(drawable,tmpstr)/2,ymax-40,tmpstr);

    j_drawline(drawable,xmin+30,ymin,xmin+30,ymax-1);
    sprintf(tmpstr,"YMax = %d",ymax);
    j_drawstring(drawable,xmin+50,40,tmpstr);

    j_setnamedcolor(drawable,J_MAGENTA);\
    for(i=1;i<=10;i++)
    	j_drawoval(drawable,xmin+(xmax-xmin)/2,ymin+(ymax-ymin)/2,(xmax-xmin)/20*i,(ymax-ymin)/20*i);

	/* Text */
    j_setnamedcolor(drawable,J_BLUE);
	y=ymin;
	for(i=5;i<22;i++)
	{
		j_setfontsize(drawable,i);
		x = xmax-j_getstringwidth(drawable,"JAPI Test Text");
    	y += j_getfontheight(drawable);
    	j_drawstring(drawable,x,y,"JAPI Test Text");
	}

    /* Images */
    if((image = j_loadimage("images/twux.gif"))>0)
    {
	    j_drawimage(drawable,image,100,200);
	    j_drawscaledimage(drawable,image,10,0,35,30,100,300,110,138);
	}

}


int main()
{

    int frame,printer,canvas,image,obj;
    int menubar,file,print,save,quit;

    /* graphical Objects */
    j_setdebug(1);

    if(!j_start())
        printf("can't connect to JAPI server\n"),exit(0);
    frame = j_frame("");
    j_setborderlayout(frame);

    menubar = j_menubar(frame);
    file    = j_menu(menubar,"File");
    print   = j_menuitem(file,"Print");
    save    = j_menuitem(file,"Save BMP");
    quit    = j_menuitem(file,"Quit");
    canvas  = j_canvas(frame,400,600);
    j_pack(frame);
    j_show(frame);

	drawgraphics(canvas,0,0,j_getwidth(canvas),j_getheight(canvas));
    obj=0;
    while((obj!=frame) && (obj!=quit))
    {
    	obj=j_nextaction();

    	if(obj==canvas)
    	{
			j_setnamedcolorbg(canvas,J_WHITE);
	        drawgraphics(canvas,10,10,j_getwidth(canvas)-10,j_getheight(canvas)-10);
		}

    	if(obj==print)
    	{
    	    if((printer = j_printer(frame))>0)
    	    {
		    	drawgraphics(printer,40,40,j_getwidth(printer)-80,j_getheight(printer)-80);
	    	    j_print(printer);
		    	drawgraphics(printer,40,40,j_getwidth(printer)-80,j_getheight(printer)-80);
	    	    j_print(printer);
	    	    j_dispose(printer);
			}
    	}

    	if(obj==save)
    	{
			/* NOTE:
				problems with WinNT 24 Bit Colordepth (use 16 Bit) */

    		image = j_image(600,800);
	    	drawgraphics(image,0,0,600,800);
    		if(!j_saveimage(image,"test.bmp",J_BMP))
	    		j_alertbox(frame,"Problems","Can't save image","OK");
     	}
    }

    j_quit();
    exit(0);
}

