#include <stdio.h>
#include "japi.h"

int main()
{
    int obj,frame,align,orient,fill,pack;
    int alignment   = J_TOP;
    int dofill      = J_FALSE;
    int orientation = J_HORIZONTAL;

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphical Objects */
    frame     = j_frame("Flow Layout Demo");
    j_setsize(frame,800,600);

    j_setflowlayout(frame,orientation);
    j_setalign(frame,alignment);

    align   = j_button(frame,"alignment");
    orient  = j_button(frame,"orientation");
    fill    = j_button(frame,"fill");
    pack    = j_button(frame,"pack");

    j_sethgap(frame,10);
    j_setvgap(frame,10);


    j_setsize(align,100,100);
    j_setsize(orient,200,200);

    j_show(frame);

    while((obj=j_nextaction())!=frame)
    {
        if(obj==align)
        {
            switch(alignment)
            {
                case(J_LEFT)        : alignment = J_CENTER; break;
                case(J_CENTER)      : alignment = J_RIGHT; break;
                case(J_RIGHT)       : alignment = J_TOP; break;
                case(J_TOP)         : alignment = J_BOTTOM; break;
                case(J_BOTTOM)      : alignment = J_TOPLEFT; break;
                case(J_TOPLEFT)     : alignment = J_TOPRIGHT; break;
                case(J_TOPRIGHT)    : alignment = J_BOTTOMLEFT; break;
                case(J_BOTTOMLEFT)  : alignment = J_BOTTOMRIGHT; break;
                case(J_BOTTOMRIGHT) : alignment = J_LEFT; break;
            }
            j_setalign(frame,alignment);
        }

        if(obj==pack)
               j_pack(frame);

        if(obj==fill)
        {
            dofill=dofill?J_FALSE:J_TRUE;
            j_setflowfill(frame,dofill);
        }

        if(obj==orient)
        {
            orientation = (orientation==J_VERTICAL)?J_HORIZONTAL:J_VERTICAL;
            j_setflowlayout(frame,orientation);
            j_setalign(frame,alignment);
            j_setflowfill(frame,dofill);
        }
    }

    j_quit();
    exit(0);
}


