#include <stdio.h>
#include "japi.h"

int main()
{
    /* graphical Objects */
    int frame,menubar,file,quit,obj;
    int label;
    int font,courier,helvetia,times,dialogin,dialogout;
    int style,normal,bold,italic;
    int size,f10,f12,f14,f18;
    int fontstyle;
    char str[256];

    j_setdebug(5);

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphic Objects */
    frame     = j_frame("Font Demo");
    menubar   = j_menubar(frame);
    file      = j_menu(menubar,"File");
    quit      = j_menuitem(file,"Quit");


    font      = j_menu(menubar,"Font");
    courier   = j_menuitem(font,"Courier");
    helvetia  = j_menuitem(font,"Helvetia");
    times     = j_menuitem(font,"Times");
    dialogin  = j_menuitem(font,"DialogIn");
    dialogout = j_menuitem(font,"DialogOut");

    style     = j_menu(menubar,"Style");
    normal    = j_menuitem(style,"Plain");
    bold      = j_checkmenuitem(style,"Bold");
    italic    = j_checkmenuitem(style,"Italic");

    size      = j_menu(menubar,"Size");
    f10       = j_menuitem(size,"10 pt");
    f12       = j_menuitem(size,"12 pt");
    f14       = j_menuitem(size,"14 pt");
    f18       = j_menuitem(size,"18 pt");

    label     = j_label(frame,"abcdefghijklmnopqrstuvwxyz");
    j_setsize(label,400,120);
    j_setpos(label,5,60);

    fontstyle = J_PLAIN;

    j_setfont(frame,J_HELVETIA,J_PLAIN,12);

    j_pack(frame);
    j_show(frame);

    obj = -1;
    while((obj!=quit) && (obj != frame))
    {
        obj=j_nextaction();

        if(obj==courier)   j_setfontname(label,J_COURIER);
        if(obj==helvetia)  j_setfontname(label,J_HELVETIA);
        if(obj==times)     j_setfontname(label,J_TIMES);
        if(obj==dialogin)  j_setfontname(label,J_DIALOGIN);
        if(obj==dialogout) j_setfontname(label,J_DIALOGOUT);

        if(obj==normal)
        {
            fontstyle=J_PLAIN;
            j_setstate(bold,J_FALSE);
            j_setstate(italic,J_FALSE);
            j_setfontstyle(label,fontstyle);
        }
        if(obj==bold)
        {
            if(j_getstate(bold)==J_TRUE)
                fontstyle+=J_BOLD;
            else
                fontstyle-=J_BOLD;
            j_setfontstyle(label,fontstyle);
        }
        if(obj==italic)
        {
            if(j_getstate(italic)==J_TRUE)
                fontstyle+=J_ITALIC;
            else
                fontstyle-=J_ITALIC;
            j_setfontstyle(label,fontstyle);
        }

        if(obj==f10)     j_setfontsize(label,10);
        if(obj==f12)     j_setfontsize(label,11);
        if(obj==f14)     j_setfontsize(label,13);
        if(obj==f18)     j_setfontsize(label,18);

        sprintf(str,"StringWidth = %d FontHeight = %d Font  Ascent = %d",
            j_getstringwidth(label,"abcdefghijklmnopqrstuvwxyz"),
            j_getfontheight(label),j_getfontascent(label));
        j_settext(frame,str);

    }
    j_quit();
    exit(0);
}


