#include <stdio.h>
#include <stdlib.h>
#include "japi.h"


int main()
{
    /* graphical Objects */
    int frame,canvas;
    int x[10]={10,20,30,40,50,60,70,80,90,100};
    int y[10]={10,90,10,90,10,90,10,90,10,90};

    j_setdebug(4);

    if(!j_start())
        printf("can't connect to JAPI server\n"),exit(0);

    /* Generate Graphical Objects */
    frame   = j_frame("Graphik Primitiven");
	j_setsize(frame,720,260);

    canvas  = j_canvas(frame,700,230);
    j_setpos(canvas,10,30);

    j_show(frame);
    j_pack(frame);

    j_setnamedcolor(canvas,J_BLUE);

//  j_cliprect(canvas,30,30,170,170);

    /* Normal */

    j_translate(canvas,10,10);
    j_drawline(canvas,10,10,90,90);
    j_drawstring(canvas,0,105,"Line");

    j_translate(canvas,100,0);
    j_drawpolygon(canvas,10,x,y);
    j_drawstring(canvas,0,105,"Polygon");

    j_translate(canvas,100,0);
    j_drawrect(canvas,10,10,80,80);
    j_drawstring(canvas,0,105,"Rectangle");

    j_translate(canvas,100,0);
    j_drawroundrect(canvas,10,10,80,80,20,20);
    j_drawstring(canvas,0,105,"RoundRect");

    j_translate(canvas,100,0);
    j_drawcircle(canvas,50,50,40);
    j_drawstring(canvas,0,105,"Circle");

    j_translate(canvas,100,0);
    j_drawoval(canvas,50,50,40,20);
    j_drawstring(canvas,0,105,"Oval");

    j_translate(canvas,100,0);
    j_drawarc(canvas,50,50,40,30,113,370);
    j_drawstring(canvas,0,105,"Arc");


    /* Filled */

    j_translate(canvas,-600,100);
    j_drawpolyline(canvas,10,x,y);
    j_drawstring(canvas,0,105,"Polyline");

    j_translate(canvas,100,0);
    j_fillpolygon(canvas,10,x,y);
    j_drawstring(canvas,0,105,"FillPolygon");

    j_translate(canvas,100,0);
    j_fillrect(canvas,10,10,80,80);
    j_drawstring(canvas,0,105,"FillRectangle");

    j_translate(canvas,100,0);
    j_fillroundrect(canvas,10,10,80,80,20,20);
    j_drawstring(canvas,0,105,"FillRoundRect");

    j_translate(canvas,100,0);
    j_fillcircle(canvas,50,50,40);
    j_drawstring(canvas,0,105,"FillCircle");

    j_translate(canvas,100,0);
    j_filloval(canvas,50,50,40,20);
    j_drawstring(canvas,0,105,"FillOval");

    j_translate(canvas,100,0);
    j_fillarc(canvas,50,50,40,30,113,370);
    j_drawstring(canvas,0,105,"FillArc");


    /* Waiting for actions */
    while(j_nextaction()!=frame);

    j_quit();

    exit(0);
}

