#include <stdio.h>
#include <malloc.h>
#include "japi.h"


int main()
{

     /* graphical Objects */
    int frame,menubar;
    int file,insets;
    int quit,plus,minus;
    int canvas,obj;
    int w,h;

    j_setdebug(3);

    if(!j_start())
        printf("can't connect to japi-server\n"),exit(0);

    /* Components */
    frame     = j_frame("Insets Demo");
    j_setborderlayout(frame);

    menubar = j_menubar(frame);
    file    = j_menu(menubar,"File");
    insets  = j_menu(menubar,"Insets");
    quit    = j_menuitem(file,"Quit");
    plus    = j_menuitem(insets,"Insets + 10");
    minus   = j_menuitem(insets,"Insets - 10");

    canvas  = j_canvas(frame,320,240);
    j_setnamedcolor(canvas,J_RED);

    j_pack(frame);
    j_show(frame);

    /* Main Loop */
    obj=0;   
    while((obj!=quit) &&(obj!=frame))
    {
        obj=j_nextaction();

        if(obj==canvas)
        {
            j_setnamedcolorbg(canvas,J_WHITE);
            w = j_getwidth(canvas)-1;
            h = j_getheight(canvas)-1;
            j_drawrect(canvas,0,0,w,h);
            j_drawline(canvas,0,0,w,h);
            j_drawline(canvas,0,h,w,0);
        }
		
	if(obj==plus)
            j_setinsets(frame,j_getinsets(frame,J_TOP)+10,j_getinsets(frame,J_BOTTOM)+10,
		              j_getinsets(frame,J_LEFT)+10,j_getinsets(frame,J_RIGHT)+10);
	if(obj==minus)
            j_setinsets(frame,j_getinsets(frame,J_TOP)-10,j_getinsets(frame,J_BOTTOM)-10,
		              j_getinsets(frame,J_LEFT)-10,j_getinsets(frame,J_RIGHT)-10);
        
    }
    j_quit();

    exit(0);
}
