#include <stdio.h>
#include "japi.h"

#define MAXPATH     256

int mandel(double zre, double zim, int maxiter)
{
    double x,y,tmp,betrag;
    int iter;

    x=y=0.0;
    iter=0;
    betrag=0.0;

    while(iter++ < maxiter)
    {
        tmp=x*x-y*y+zre;
        y=2*x*y+zim;
        x=tmp;
        if((betrag = x*x + y*y) > 4.0) return(iter);
    }
    return(maxiter);
}

int main()
{

    int breite=640;
    int hoehe=480;
    int x,y,do_work=0,it;
    double zre,zim;
    double xstart,ystart,xend,yend;

    /* graphical Objects */
    int frame,menubar;
    int file,calc;
    int quit,start,stop;
    int canvas,obj;

    /* mandelbrot area */
    xstart = -1.8;
    xend   =  0.8;
    ystart = -1.0;
    yend   =  1.0;


//    j_setdebug(0);

    if(! j_start())
        printf("can't connect to JAPI Kernel\n"),exit(0);

//    j_setdebug(4);

    frame   = j_frame("Variables Mandelbrot");
    j_setborderlayout(frame);

    menubar = j_menubar(frame);
    file    = j_menu(menubar,"File");
    calc    = j_menu(menubar,"Calc");
    quit    = j_menuitem(file,"Quit");
    start   = j_menuitem(calc,"Start");
    stop    = j_menuitem(calc,"Stop");

    canvas  = j_canvas(frame,breite,hoehe);

    j_pack(frame);
    j_show(frame);
//    j_pack(frame);
//   j_show(frame);


    /* Waiting for actions */
    x=-1,y=-1;
    while(1)
    {
        if(do_work)
            obj=j_getaction();
        else
            obj=j_nextaction();

        if(obj==quit)
            break;

        if(obj==start)
        {
            x=-1,y=-1;
            do_work=1;
            j_setnamedcolor(canvas,J_WHITE);
        }
        if(obj==stop)
            do_work=0;

        if(do_work)
        {
            x=(x+1)%breite;
            if(x==0)
                y=(y+1)%hoehe;
            if((x==breite-1) && (y==hoehe-1))
                do_work=0;
            else
            {
                zre = xstart + x*(xend-xstart)/breite;
                zim = ystart + y*(yend-ystart)/hoehe;
                it = mandel(zre,zim,512);
                j_setcolor(canvas,(char)(it*11),(char)(it*13),(char)(it*17));
                j_drawpixel(canvas,x,y);
            }
        }

        if(obj==canvas)
        {
            breite = j_getwidth(canvas);
            hoehe  = j_getheight(canvas);
            x=-1,y=-1;
        }

    }
    j_quit();

    exit(0);
}

