#include <stdio.h>
#include <malloc.h>
#include "japi.h"

int mandel(double zre, double zim, int maxiter)
{
    double x,y,tmp,betrag;
    int iter;

    x=y=0.0;
    iter=0;
    betrag=0.0;

    while(iter++ < maxiter)
    {
        tmp=x*x-y*y+zre;
        y=2*x*y+zim;
        x=tmp;
        if((betrag = x*x + y*y) > 4.0) return(iter);
    }
    return(maxiter);
}

int main()
{

    int breite=1024;
    int hoehe=708;
    int x,y,do_work=0,it;
    double zre,zim;
    double xstart=0,ystart=0,xend=0,yend=0;
    double lxs,lxe,lys,lye;
    int mxs=0,mys=0,mxe=0,mye=0;
    int *r=NULL,*g=NULL,*b=NULL;

    /* graphical Objects */
    int frame,menubar;
    int file,calc;
    int print,quit,start,stop,reset;
    int canvas,obj;
    int pressed,dragged;

    /* mandelbrot area */
    lxs = -1.8;
    lxe =  0.8;
    lys = -1.0;
    lye =  1.0;

	j_setdebug(0);

    if(!j_start())
        printf("can't connect to japi-server\n"),exit(0);

    /* Components */
    frame     = j_frame(NULL);
    j_setborderlayout(frame);

    menubar = j_menubar(frame);
    file    = j_menu(menubar,"File");
    calc    = j_menu(menubar,"Calc");
    print   = j_menuitem(file,"Print");
    quit    = j_menuitem(file,"Quit");
    start   = j_menuitem(calc,"Start");
    stop    = j_menuitem(calc,"Stop");
    reset   = j_menuitem(calc,"Reset");

    canvas  = j_canvas(frame,breite,hoehe);

    pressed  = j_mouselistener(canvas,J_PRESSED);
    dragged  = j_mouselistener(canvas,J_DRAGGED);

/*
	printf("%d %d %d %d\n",j_getinsets(frame,J_TOP),j_getinsets(frame,J_BOTTOM),
						   j_getinsets(frame,J_LEFT),j_getinsets(frame,J_RIGHT));
	j_setinsets(frame,j_getinsets(frame,J_TOP)+15,j_getinsets(frame,J_BOTTOM)+5,
			 	      j_getinsets(frame,J_LEFT)+5,j_getinsets(frame,J_RIGHT)+5);
	printf("%d %d %d %d\n",j_getinsets(frame,J_TOP),j_getinsets(frame,J_BOTTOM),
						   j_getinsets(frame,J_LEFT),j_getinsets(frame,J_RIGHT));
*/
    j_show(frame);
    j_pack(frame);

    /* Main Loop */
    x=y=-1;
	obj=0;
    while((obj!=quit) &&(obj!=frame))
    {
        if(do_work)
            obj=j_getaction();
        else
            obj=j_nextaction();
printf("%d\n",obj);

        if(obj==reset)
        {
		    lxs = xstart = -1.8;
    		lxe = xend   =  0.8;
    		lys = ystart = -1.0;
    		lye = yend   =  1.0;
            x=y=-1;
            j_setnamedcolorbg(canvas,J_WHITE);
        }

        if(obj==start)
        {
 		    xstart = lxs;
    		xend   = lxe;
    		ystart = lys;
    		yend   = lye;
            x=y=-1;
            do_work=1;
            j_setnamedcolorbg(canvas,J_WHITE);
        }

        if(obj==stop)
            do_work=0;

        if(obj==print)
            j_print(canvas);

        if(obj==canvas)
        {
            breite = j_getwidth(canvas);
            hoehe  = j_getheight(canvas);
 			printf("Canvas resize %d  %d\n",breite,hoehe);
            x=y=-1;
            r = realloc(r,hoehe*breite);
            g = realloc(g,hoehe*breite);
            b = realloc(b,hoehe*breite);
            j_setnamedcolorbg(canvas,J_WHITE);
        }

        if(do_work)
		{
			y++;
			if(y == hoehe)
			{
			    y=0;
				do_work=0;
			}
			else
			{
				for(x=0;x<breite;x++)
				{
                    zre = xstart + x*(xend-xstart)/breite;
                    zim = ystart + y*(yend-ystart)/hoehe;
                    it = mandel(zre,zim,512);
					r[x]=it*11;
					g[x]=it*13;
					b[x]=it*17;
			}
				j_drawimagesource(canvas,0,y,breite,1,r,g,b);
				j_sync();
			}
		}

        if(obj == pressed)
        {
            j_setxor(canvas,J_TRUE);
            j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys);
            mxe=j_getmousex(pressed);
            mye=j_getmousey(pressed);
            mxs=mxe;
            mys=mye;
            j_setxor(canvas,J_FALSE);
        }

        if(obj == dragged)
        {
            j_setxor(canvas,J_TRUE);
            j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys);
            mxe=j_getmousex(dragged);
            mye=j_getmousey(dragged);
            j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys);
            j_setxor(canvas,J_FALSE);
            lxs = xstart+(xend-xstart)*mxs/breite;
            lxe = xstart+(xend-xstart)*mxe/breite;
            lys = ystart+(yend-ystart)*mys/hoehe;
            lye = ystart+(yend-ystart)*mye/hoehe;
       }

    }
    j_quit();

    exit(0);
}
