#include <stdio.h>
#include "japi.h"

#define MAXPATH     256

int main()
{
    /* graphical Objects */
    int frame,menubar,submenu;
    int file,edit,options,help;
    int open,save,quit,about;
    int cut,copy,paste;
    int enable,settings;
    int obj;
    char inhalt[1024];

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphical Objects */
    frame    = j_frame(NULL);

    menubar  = j_menubar(frame);
    file     = j_menu(menubar,"File");
    edit     = j_menu(menubar,"Edit");
    options  = j_menu(menubar,"Options");
    submenu  = j_menu(options,"Settings");
    help     = j_helpmenu(menubar,"Help");

    open     = j_menuitem(file,"Open");
    save     = j_menuitem(file,"Save");
    j_seperator(file);
    quit     = j_menuitem(file,"Quit");
    j_disable(save);
    j_setshortcut(quit,'q');

    cut      = j_menuitem(edit,"Cut");
    copy     = j_menuitem(edit,"Copy");
    paste    = j_menuitem(edit,"Paste");

    about    = j_menuitem(help,"About");

    enable   = j_checkmenuitem(submenu,"Enable Settings");
    settings = j_menuitem(submenu,"Settings");
    j_disable(settings);

    j_show(frame);

    /* Waiting for actions */
    while(1)
    {
        obj=j_nextaction();

        if(obj==enable)
        {
            if(j_getstate(enable)==J_FALSE)
                j_disable(settings);
            else
                j_enable(settings);
        }
        if(obj==cut)
        {
            j_gettext(cut,inhalt);
            if(strcmp(inhalt,"Cut")==0)
                j_settext(cut,"Ausschneiden");
            else
                j_settext(cut,"Cut");
        }
        if(obj==copy)
        {
            j_gettext(copy,inhalt);
            if(strcmp(inhalt,"Copy")==0)
                j_settext(copy,"Kopieren");
            else
                j_settext(copy,"Copy");
        }
        if(obj==paste)
        {
            j_gettext(paste,inhalt);
            if(strcmp(inhalt,"Paste")==0)
                j_settext(paste,"Einfuegen");
            else
                j_settext(paste,"Paste");
        }

        if((obj==quit) || (obj==frame))
        {
        	j_dispose(menubar);
        //    break;
		}
    }
    j_quit();

    exit(0);
}
