#include <stdio.h>
#include "japi.h"

int main()
{

    int frame,obj;
    int canvas1,canvas2;
    int pressed,released,moved,dragged,entered,exited;
    int startx=0,starty=0;
    int x,y;

    j_setdebug(0);

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphical Objects */
    frame     = j_frame("move and drag the Mouse");
    j_setsize(frame,430,240);
    j_setnamedcolorbg(frame,J_LIGHT_GRAY);

    canvas1=j_canvas(frame,200,200);
    canvas2=j_canvas(frame,200,200);

    j_setpos(canvas1,10,30);
    j_setpos(canvas2,220,30);

    pressed  = j_mouselistener(canvas1,J_PRESSED);
    dragged  = j_mouselistener(canvas1,J_DRAGGED );
    released = j_mouselistener(canvas1,J_RELEASED);
    entered  = j_mouselistener(canvas2,J_ENTERERD);
    moved    = j_mouselistener(canvas2,J_MOVED);
    exited   = j_mouselistener(canvas2,J_EXITED);

    j_show(frame);

    /* Waiting for actions */
    while((obj=j_nextaction())!=frame)
    {
        if(obj == pressed)
        {
            j_getmousepos(pressed,&x,&y);
//            printf("Mouse Pressed in Canvas 1 at %d %d\n",x,y);
            startx=x;
            starty=y;
        }

        if(obj == dragged)
        {
            j_getmousepos(dragged,&x,&y);
//            printf("Mouse Dragged in Canvas 1 to %d %d\n",x,y);
            j_drawrect(canvas1,startx,starty,x-startx,y-starty);
        }

        if(obj == released)
        {
            j_getmousepos(released,&x,&y);
//            printf("Mouse Released in Canvas 1 at %d %d\n",x,y);
            j_drawrect(canvas1,startx,starty,x-startx,y-starty);
        }

        if(obj == entered)
        {
            j_getmousepos(entered,&x,&y);
//            printf("Mouse Entered in Canvas 2 at %d %d\n",x,y);
            startx=x;
            starty=y;
        }

        if(obj == moved)
        {
            j_getmousepos(moved,&x,&y);
//            printf("Mouse Moved in Canvas 2 to %d %d\n",x,y);
            j_drawline(canvas2,startx,starty,x,y);
            startx=x;
            starty=y;
        }
        if(obj == exited)
        {
            j_getmousepos(exited,&x,&y);
//            printf("Mouse Exited in Canvas 2 to %d %d\n",x,y);
            j_drawline(canvas2,startx,starty,x,y);
        }
    }
    j_quit();
    exit(0);
}


