#include <stdio.h>
#include "japi.h"

int main()
{

    int frame,obj;
    int canvas;
    int pressed,dragged;
    int startx,starty,x,y;

    j_setdebug(3);

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphical Objects */
    frame     = j_frame("move and drag the Mouse");

    canvas=j_canvas(frame,230,220);
    j_setpos(canvas,10,30);

    j_show(frame);
    j_pack(frame);

    pressed  = j_mouselistener(canvas,J_PRESSED);
    dragged  = j_mouselistener(canvas,J_DRAGGED);

    j_setnamedcolor(canvas,J_BLUE);
    j_fillrect(canvas,0,0,230,110);
    j_setnamedcolor(canvas,J_YELLOW);
    j_fillrect(canvas,0,110,230,110);

    j_setnamedcolor(canvas,J_RED);

    /* Waiting for actions */
    startx=starty=x=y=0;
    while(1)
    {
        obj=j_nextaction();

        if(obj==frame)
            break;

        if(obj == pressed)
        {
            j_setxor(canvas,J_TRUE);
            j_drawrect(canvas,startx,starty,x-startx,y-starty);
            j_getmousepos(pressed,&x,&y);
            startx=x;
            starty=y;
            j_setxor(canvas,J_FALSE);
        }

        if(obj == dragged)
        {
            j_setxor(canvas,J_TRUE);
            j_drawrect(canvas,startx,starty,x-startx,y-starty);
            j_getmousepos(dragged,&x,&y);
            j_drawrect(canvas,startx,starty,x-startx,y-starty);
            j_setxor(canvas,J_FALSE);
        }
    }
    j_quit();
    exit(0);
}


