#include <stdio.h>
#include "japi.h"

int main()
{
    /* graphical Objects */
    int frame,obj;
    int scrollpane,vscroll,hscroll,canvas;
    int x=0,y=0,width=400,height=400;

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphic Objects */
    frame       = j_frame("Scrollpane Demo");
    j_setborderlayout(frame);

    scrollpane  = j_scrollpane(frame);
    vscroll     = j_vscrollbar(scrollpane);
    hscroll     = j_hscrollbar(scrollpane);

    canvas=j_canvas(scrollpane,400,400);

    j_setsize(scrollpane,180,150);

    j_show(frame);
    j_pack(frame);

    for(x=0;x<400;x+=10)
    {
        j_drawline(canvas,x,0,0,400-x);
        j_drawline(canvas,x,400,400,400-x);
    }

    while(1)
    {
        obj=j_nextaction();

        if(obj==scrollpane)
        {
            width =j_getviewportwidth(scrollpane);
            height=j_getviewportheight(scrollpane);

        }
        if(obj==hscroll)
            x=j_getvalue(hscroll);
        if(obj==vscroll)
            y=j_getvalue(vscroll);

        printf("Viewport X = %d:%d (Width  = %d)\n",x,x+width ,width);
        printf("         Y = %d:%d (Height = %d)\n",y,y+height,height);

        if(obj == frame)
            break;
    }
    j_quit();
    exit(0);
}


