#include <stdio.h>
#include "japi.h"

int main()
{
    char* newtext="JAPI (Java Application\nProgramming Interface)\na platform and language\nindependent API";

    /* graphical Objects */
    int frame,panel,menubar,file,new,save,quit,obj;
    int edit,selall,cut,copy,paste;
    int text,selstart=0,selend=0;
    char inhalt[2<<16];

    j_setdebug(3);

    if(!j_start())
        printf("can't connect to server\n"),exit(0);

    /* Generate Graphical Objects */
    frame   = j_frame("A simple editor");
    j_setgridlayout(frame,1,1);
    panel   = j_panel(frame);
    j_setgridlayout(panel,1,1);

    menubar = j_menubar(frame);
    file    = j_menu(menubar,"File");
    new     = j_menuitem(file,"New");
    save    = j_menuitem(file,"Save");
    j_seperator(file);
    quit    = j_menuitem(file,"Quit");


    edit    = j_menu(menubar,"Edit");
    selall  = j_menuitem(edit,"Select All");
    j_seperator(edit);
    cut     = j_menuitem(edit,"Cut");
    copy    = j_menuitem(edit,"Copy");
    paste   = j_menuitem(edit,"Paste");

    text    = j_textarea(panel,15,4);
    j_setfont(text,J_DIALOGIN,J_BOLD,18);
 //   j_setpos(text,10,60);
    j_settext(text,newtext);

    j_show(frame);
	j_pack(frame);

j_setrows(text,4);
j_setcolumns(text,15);
	j_pack(frame);

    while(1)
    {
fflush(stdout);
        obj=j_nextaction();

        if((obj==quit) || (obj == frame))
        {
            j_quit();
            break;
        }

		if(obj==panel)
		{
			printf("Size changed to %d rows %d columns\n",j_getrows(text),j_getcolumns(text));
			printf("Size changed to %d x %d pixel\n",j_getwidth(text),j_getheight(text));
		}

        if(obj==text)
            printf("text changed (len=%d)\n",j_getlength(text));

        if(obj==new)
            j_settext(text,newtext);

        if(obj==save)
        {
            j_gettext(text,inhalt);
            printf("BEGIN\n%s\nEND\n",inhalt);
        }

        if((obj==quit) || (obj == frame))
        {
            j_quit();
            break;
        }

        if(obj==selall)
            j_selectall(text);

        if((obj==cut)||(obj==copy)||(obj==paste))
        {
            selstart=j_getselstart(text);
            selend  =j_getselend(text);
        }
        if(obj==cut)
        {
            j_delete(text,selstart,selend);
            j_selecttext(text,selstart,selend);
        }
        if(obj==copy)
            j_getseltext(text,inhalt);

        if(obj==paste)
        {
            if(selstart==selend)
                j_inserttext(text,inhalt,j_getcurpos(text));
            else
                j_replacetext(text,inhalt,selstart,selend);
            j_setcurpos(text,selstart);
        }

    }

    exit(0);
}


