#include <stdio.h>
#include "japi.h"


int main()
{
    int frame,canvas,menubar,obj=0;
    int file,open,bmp,ppm,quit;
    int image=0;
    char filename[256];

    j_setdebug(0);

    if(!j_start())
        printf("can't connect to JAPI server\n"),exit(0);

    /* Generate Graphical Objects */
    frame   = j_frame("Image Viewer");
    menubar = j_menubar(frame);
    file    = j_menu(menubar,"File");
    open    = j_menuitem(file,"Open");
    bmp    = j_menuitem(file,"Save BMM");
    ppm    = j_menuitem(file,"Save PPM");
    j_seperator(file);
    quit    = j_menuitem(file,"Quit");

    canvas  = j_canvas(frame,320,240);
    j_setgridlayout(frame,1,1);
    j_setresizable(frame,J_FALSE);
    j_disable(bmp);
    j_disable(ppm);
    j_pack(frame);
    j_show(frame);
	sprintf(filename,"images\\lkjdsfalkdsja");

    while((obj!=frame) && (obj!=quit))
    {
    	obj=j_nextaction();

    	if(obj==open)
    	{
    	    j_fileselect(frame,"Open File","*",filename);
            if(strlen(filename)>1)
            {
                image  = j_loadimage(filename);
                if(image == -1)
                    j_alertbox(frame,"Warning","Not a valid image file","Shit");
                else
                {
                    j_setsize(canvas,j_getwidth(image),j_getheight(image));
                    j_pack(frame);
                    j_setnamedcolorbg(canvas,J_WHITE);
    	            j_drawimage(canvas,image,0,0);
                    j_enable(bmp);
                    j_enable(ppm);
                }
            }
        }

        if(obj==bmp)
        {
            j_fileselect(frame,"Save as BMP","*.bmp",filename);
            if(strlen(filename)>1)
                j_saveimage(image,filename,J_BMP);
        }

        if(obj==ppm)
        {
            j_fileselect(frame,"Save as PPM","*.ppm",filename);
            if(strlen(filename)>1)
                   j_saveimage(image,filename,J_PPM);
        }
    }


    j_quit();

    exit(0);
}

