C       Example drawables.f

        INCLUDE "japi.f"

 
        integer frame,printer,canvas,image,obj
        integer menubar,file,print,save,quit

        call j_setdebug(1)

        if( .not. j_start()) then
            write(*,*) "can't connect to JAPI server"   
            goto 20
        endif
        frame = j_frame("")
        call j_setborderlayout(frame)

        menubar = j_menubar(frame)
        file    = j_menu(menubar,"File")
        print   = j_menuitem(file,"Print")
        save    = j_menuitem(file,"Save BMP")
        quit    = j_menuitem(file,"Quit")
        canvas  = j_canvas(frame,400,600)
        call j_pack(frame)
        call j_show(frame)

	call drawgraphics(canvas,0,0,j_getwidth(canvas)-10,
     &                               j_getheight(canvas))
  
10      obj =  j_nextaction()

    	   if(obj .eq. canvas) then
              call j_setnamedcolorbg(canvas,J_WHITE)
	      call drawgraphics(canvas,10,10,j_getwidth(canvas)-10,
     &                                       j_getheight(canvas)-10)
           endif

    	   if(obj .eq. print) then
              printer = j_printer(frame)
              if (printer .gt. 0) then
 	      	  call drawgraphics(printer,40,40,j_getwidth(printer)-80,
     &                                        j_getheight(printer)-80)
    	      	  call j_print(printer)
    	      endif
    	   endif

    	   if(obj .eq. save) then
C	      NOTE: problems with WinNT 24 Bit Colordepth (use 16 Bit) 
              image = j_image(600,800)
	      call drawgraphics(image,0,0,600,800)
    	      if(.not. j_saveimage(image,"test.bmp",J_BMP)) 
     &           a=j_alertbox(frame,"Problems","Can't save image","OK")
     	    endif
     	    
            if((obj .eq. quit) .or. (obj .eq. frame)) goto20
        goto 10

20      call j_quit()
        end

        subroutine drawgraphics(drawable,xmin,ymin,xmax,ymax)
        integer drawable,xmin,ymin,xmax,ymax 
 
        INCLUDE "japi.f"
 
        integer image,i,fntsize,x,y
        character*256  tmpstr
        
        fntsize=10
        call j_setfontsize(drawable,fntsize)
        call j_setnamedcolor(drawable,J_RED)

C       Drawings 
        call j_drawline(drawable,xmin,ymin,xmax-1,ymax-1)
        call j_drawline(drawable,xmin,ymax-1,xmax-1,ymin)
        call j_drawrect(drawable,xmin,ymin,xmax-xmin-1,ymax-xmin-1)

        call j_setnamedcolor(drawable,J_BLACK)
        call j_drawline(drawable,xmin,ymax-30,xmax-1,ymax-30)
        write(tmpstr,*) "XMax = ",xmax
        call j_drawstring(drawable,
     &                    xmax/2-j_getstringwidth(drawable,tmpstr)/2,
     &                    ymax-40,tmpstr)

        call j_drawline(drawable,xmin+30,ymin,xmin+30,ymax-1)
        write(tmpstr,*) "YMax = ",ymax
        call j_drawstring(drawable,xmin+50,40,tmpstr)

        call j_setnamedcolor(drawable,J_MAGENTA)
        do i=1,10
    	   call j_drawoval(drawable,xmin+(xmax-xmin)/2,ymin+(ymax-ymin)/2,
     &                             (xmax-xmin)/20*i,(ymax-ymin)/20*i)
        enddo
        
C       Text 
        call j_setnamedcolor(drawable,J_BLUE)
        y=ymin
	do i=5,22
           call j_setfontsize(drawable,i)
	   x = xmax-j_getstringwidth(drawable,"JAPI Test Text")
    	   y = y+j_getfontheight(drawable)
    	   call j_drawstring(drawable,x,y,"JAPI Test Text")
        enddo

C       Images 
        image = j_loadimage("images/twux.gif")
        if(image .gt. 0) then
           call j_drawimage(drawable,image,100,200)
           call j_drawscaledimage(drawable,image,10,0,35,30,
     &                                       100,300,110,138)
	endif
	end


