C       Example font.f

        INCLUDE "japi.f"
 	
        integer frame,menubar,file,quit,obj,label
        integer font,courier,helvetia,times,dialogin,dialogout
        integer style,normal,bold,italic
        integer size,f10,f12,f14,f18
        integer fontstyle
        character*(256) str

        call j_setdebug(5)

        if( .not. j_start()) then
            write(*,*) "can't connect to JAPI server"   
            goto 20
        endif

        frame     = j_frame("Font Demo")
        menubar   = j_menubar(frame)
        file      = j_menu(menubar,"File")
        quit      = j_menuitem(file,"Quit")


        font      = j_menu(menubar,"Font")
        courier   = j_menuitem(font,"Courier")
        helvetia  = j_menuitem(font,"Helvetia")
        times     = j_menuitem(font,"Times")
        dialogin  = j_menuitem(font,"DialogIn")
        dialogout = j_menuitem(font,"DialogOut")

        style     = j_menu(menubar,"Style")
        normal    = j_menuitem(style,"Plain")
        bold      = j_checkmenuitem(style,"Bold")
        italic    = j_checkmenuitem(style,"Italic")

        size      = j_menu(menubar,"Size")
        f10       = j_menuitem(size,"10 pt")
        f12       = j_menuitem(size,"12 pt")
        f14       = j_menuitem(size,"14 pt")
        f18       = j_menuitem(size,"18 pt")

        label     = j_label(frame,"abcdefghijklmnopqrstuvwxyz")
        call j_setsize(label,400,120)
        call j_setpos(label,5,60)

        fontstyle = J_PLAIN

        call j_setfont(frame,J_HELVETIA,J_PLAIN,12)

        call j_pack(frame)
        call j_show(frame)

10      obj=j_nextaction()
 
           if((obj .eq. quit) .or. (obj .eq. frame)) goto 20
 	
           if(obj .eq. courier)   call j_setfontname(label,J_COURIER)
           if(obj .eq. helvetia)  call j_setfontname(label,J_HELVETIA)
           if(obj .eq. times)     call j_setfontname(label,J_TIMES)
           if(obj .eq. dialogin)  call j_setfontname(label,J_DIALOGIN)
           if(obj .eq. dialogout) call j_setfontname(label,J_DIALOGOUT)

           if(obj .eq. normal) then
              fontstyle=J_PLAIN
              call j_setstate(bold,.false.)
              call j_setstate(italic,.false.)
              call j_setfontstyle(label,fontstyle)
           endif
        
           if(obj .eq. bold) then
              if(j_getstate(bold))  then
                 fontstyle = fontstyle + J_BOLD
              else
                 fontstyle = fontstyle - J_BOLD
              endif
              call j_setfontstyle(label,fontstyle)
           endif
        
           if(obj .eq. italic) then
              if(j_getstate(italic))  then
                 fontstyle = fontstyle + J_ITALIC
              else
                 fontstyle = fontstyle - J_ITALIC
              endif
              call j_setfontstyle(label,fontstyle)
           endif

           if(obj .eq. f10) call j_setfontsize(label,10)
           if(obj .eq. f12) call j_setfontsize(label,11)
           if(obj .eq. f14) call j_setfontsize(label,13)
           if(obj .eq. f18) call j_setfontsize(label,18)
           
           write(str,*) " StringWidth = ",
     &         j_getstringwidth(label,"abcdefghijklmnopqrstuvwxyz"),
     &         " FontHeight = ",j_getfontheight(label),
     &         " FontAscent = ",j_getfontascent(label)
	        call j_settext(frame,str)

        goto 10

20      continue
        call j_quit()
        
        end

