C       Example mandel2.f 

        INCLUDE "japi.f"

        integer breite,hoehe
        integer x,y,it
        real zre,zim
        real xstart,ystart,xend,yend
        real lxs,lxe,lys,lye
        integer r(4096),g(4096),b(4096)
        logical do_work
        
        integer frame,menubar
        integer file,calc
        integer print,quit,start,stop,reset
        integer canvas,obj,pressed,dragged
    
        breite = 320
        hoehe  = 240
    
        lxs = -1.8
        lxe =  0.8
        lys = -1.0
        lye =  1.0

        if( .not. j_start()) then
            write(*,*) "can't connect to server"   
            goto 20
        endif
        
        frame   = j_frame("Mandelbrot")         
        call j_setborderlayout(frame)

        menubar = j_menubar(frame)
        file    = j_menu(menubar,"File")
        calc    = j_menu(menubar,"Calc")
        print   = j_menuitem(file,"Print")
        quit    = j_menuitem(file,"Quit")
        start   = j_menuitem(calc,"Start")
        stop    = j_menuitem(calc,"Stop")
        reset   = j_menuitem(calc,"Reset")

        canvas  = j_canvas(frame,breite,hoehe)
     
        pressed  = j_mouselistener(canvas,J_PRESSED)
        dragged  = j_mouselistener(canvas,J_DRAGGED)

        call j_show(frame)
        call j_pack(frame)
    
        x=-1
        y=-1
        do_work = .false.
	obj=0
 10     continue
                
            if(do_work) then
                obj=j_getaction()
            else
                obj=j_nextaction()
            endif
                               
            if((obj.eq.quit) .or. (obj.eq.frame))goto 20
        
            if(obj.eq.reset) then
                lxs = -1.8
                lxe =  0.8
                lys = -1.0
                lye =  1.0
		xstart = -1.8
    		xend   =  0.8
    		ystart = -1.0
    		yend   =  1.0
                x=-1
                y=-1
                call j_setnamedcolorbg(canvas,J_WHITE)
            endif
             
            if(obj.eq.start) then
  		xstart = lxs
    		xend   = lxe
    		ystart = lys
    		yend   = lye
                x=-1
                y=-1
                do_work = .true.
                call j_setnamedcolorbg(canvas,J_WHITE)
           endif
        
           if(obj.eq.stop) do_work = .false.
                        
           if(obj.eq.print) call j_print(canvas)
           
           if(obj.eq.canvas) then
               breite = j_getwidth(canvas)
               hoehe  = j_getheight(canvas)
               x=-1
               y=-1
               call j_setnamedcolorbg(canvas,J_WHITE)
           endif
           
           if(do_work) then
   		y=y+1
		if(y .eq. hoehe) then
                    y = 0
                    do_work = .false.
                else
                    do x=0,breite
                       zre = xstart + x*(xend-xstart)/breite
                       zim = ystart + y*(yend-ystart)/hoehe
                       it = mandel(zre,zim,512)
                       r(x)=it*11
                       g(x)=it*13
                       b(x)=it*17
                    enddo
                    call j_drawimagesource(canvas,0,y,breite,1,r,g,b)
                endif
            endif                                
      
            if(obj .eq. pressed) then
                call j_setxor(canvas, .true. )
                call j_setnamedcolor(canvas,J_BLACK)
                call j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys)
                call j_getmousepos(pressed,mxe,mye)
                mxs=mxe
                mys=mye
            endif

            if(obj .eq. dragged) then
                call j_setxor(canvas, .true. )
                call j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys)
                call j_getmousepos(dragged,mxe,mye)
                call j_drawrect(canvas,mxs,mys,mxe-mxs,mye-mys)
                call j_setxor(canvas, .false.)
                lxs = xstart+(xend-xstart)*mxs/breite
                lxe = xstart+(xend-xstart)*mxe/breite
                lys = ystart+(yend-ystart)*mys/hoehe
                lye = ystart+(yend-ystart)*mye/hoehe
           endif

        goto 10

20      continue
        call j_quit()        
        end


        integer function  mandel(zre,zim,maxiter)
        real zre,zim
        integer maxiter

            real x,y,tmp,betrag
            integer iter

            x=0.0
            y=0.0
            iter=0
            betrag=0.0
    
10          continue        
  
            tmp = x*x-y*y+zre
            y = 2*x*y+zim
            x = tmp
            betrag = x*x + y*y
            iter = iter + 1
        
            if(betrag.gt.4.0) goto 20
            if(iter.lt.maxiter)  goto 10
        
20          mandel=iter    
        end               

