program componentlistener

use japi

integer :: frame,obj,text,resized,moved,hidden,shown
character(len=256) :: str
    
if( .not. j_start()) then
    PRINT*, "can't connect to JAPI server"   
    go to 20
end if

frame   = j_frame("")
call j_setgridlayout(frame,1,1)

text    = j_textarea(frame,80,25)

resized = j_componentlistener(text,J_RESIZED)
moved   = j_componentlistener(frame,J_MOVED)
hidden  = j_componentlistener(text,J_HIDDEN)
shown   = j_componentlistener(text,J_SHOWN)

call j_show(frame)
      
obj = 0
nextaction: do
    obj=j_getaction()
    
    if(obj == frame) exit nextaction

    if(obj == resized) then
        write(unit=str,fmt="(a,i3,a,i3,a)") "resized to ",j_getrows(text), &
                            " rows ",j_getcolumns(text)," columns"//char(10)
        call j_appendtext(text,str)
    endif
    
    if(obj == moved) then
       call j_appendtext(text,"Frame moved"//char(10))
       if(j_isvisible(text)) then
           call j_settext(frame,"Move again to see the text!")
           call j_hide(text)
       else
           call j_settext(frame,"Component Listener")
           call j_show(text)
       endif 
    endif

    if(obj == hidden) then
       call j_appendtext(text,"Text hidden"//char(10))
    endif

    if(obj == shown) then
       call j_appendtext(text,"Text shown"//char(10))
    endif

end do nextaction

20 continue     
call j_quit()
  
end program componentlistener


