PROGRAM JFLAYOUT!       Example flowsimple.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-14  Time: 22:13:37

USE JAPI


INTEGER :: obj,frame,align,orient,fill,pack
INTEGER :: alignment,orientation
LOGICAL :: dofill

alignment   = j_top
orientation = j_horizontal
dofill      = .false.

IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to JAPI Kernel"
  GO TO 20
END IF

frame     = j_frame("Flow Layout Demo")
CALL j_setsize(frame,800,600)

CALL j_setflowlayout(frame,orientation)
CALL j_setalign(frame,alignment)

align   = j_button(frame,"alignment")
orient  = j_button(frame,"orientation")
fill    = j_button(frame,"fill")
pack    = j_button(frame,"pack")

CALL j_sethgap(frame,10)
CALL j_setvgap(frame,10)

CALL j_setsize(align,100,100)
CALL j_setsize(orient,200,200)

CALL j_show(frame)

NEXTACTION: DO
      obj=j_nextaction()

IF(obj == frame)  EXIT NEXTACTION

IF(obj == align) THEN
  
  IF(alignment == j_bottomright) THEN
    alignment = j_left
  ELSE
    IF(alignment == j_bottomleft) alignment = j_bottomright
    IF(alignment == j_topright) alignment = j_bottomleft
    IF(alignment == j_topleft) alignment = j_topright
    IF(alignment == j_bottom) alignment = j_topleft
    IF(alignment == j_top) alignment = j_bottom
    IF(alignment == j_right) alignment = j_top
    IF(alignment == j_center) alignment = j_right
    IF(alignment == j_left) alignment = j_center
  END IF
  CALL j_setalign(frame,alignment)
END IF

IF(obj == pack) CALL j_pack(frame)

IF(obj == fill) THEN
  IF (dofill) THEN
    dofill = .false.
  ELSE
    dofill = .true.
  END IF
  CALL j_setflowfill(frame,dofill)
END IF

IF(obj == orient) THEN
  IF(orientation == j_vertical) THEN
    orientation=j_horizontal
  ELSE
    orientation=j_vertical
  END IF
  CALL j_setflowlayout(frame,orientation)
  CALL j_setalign(frame,alignment)
  CALL j_setflowfill(frame,dofill)
END IF

END DO NEXTACTION

20   continue
CALL j_quit()
END PROGRAM JFLAYOUT

