PROGRAM JFONT!       Example font.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-14  Time: 23:18:09

USE JAPI


INTEGER :: frame,menubar,FILE,quit,obj,label
INTEGER :: font,courier,helvetia,times,dialogin,dialogout
INTEGER :: style,normal,bold,italic
INTEGER :: size,f10,f12,f14,f18
INTEGER :: fontstyle
CHARACTER (LEN=256) :: str

CALL j_setdebug(5)

IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to JAPI server"
  GO TO 20
END IF

frame     = j_frame("Font Demo")
menubar   = j_menubar(frame)
FILE      = j_menu(menubar,"File")
quit      = j_menuitem(FILE,"Quit")


font      = j_menu(menubar,"Font")
courier   = j_menuitem(font,"Courier")
helvetia  = j_menuitem(font,"Helvetia")
times     = j_menuitem(font,"Times")
dialogin  = j_menuitem(font,"DialogIn")
dialogout = j_menuitem(font,"DialogOut")

style     = j_menu(menubar,"Style")
normal    = j_menuitem(style,"Plain")
bold      = j_checkmenuitem(style,"Bold")
italic    = j_checkmenuitem(style,"Italic")

size      = j_menu(menubar,"Size")
f10       = j_menuitem(size,"10 pt")
f12       = j_menuitem(size,"12 pt")
f14       = j_menuitem(size,"14 pt")
f18       = j_menuitem(size,"18 pt")

label     = j_label(frame,"abcdefghijklmnopqrstuvwxyz")
CALL j_setsize(label,400,120)
CALL j_setpos(label,5,60)

fontstyle = j_plain

CALL j_setfont(frame,j_helvetia,j_plain,12)

CALL j_pack(frame)
CALL j_show(frame)

NEXTACTION: DO
      obj=j_nextaction()

IF((obj == quit) .OR. (obj == frame)) EXIT NEXTACTION

IF(obj == courier)   CALL j_setfontname(label,j_courier)
IF(obj == helvetia)  CALL j_setfontname(label,j_helvetia)
IF(obj == times)     CALL j_setfontname(label,j_times)
IF(obj == dialogin)  CALL j_setfontname(label,j_dialogin)
IF(obj == dialogout) CALL j_setfontname(label,j_dialogout)

IF(obj == normal) THEN
  fontstyle=j_plain
  CALL j_setstate(bold,.false.)
  CALL j_setstate(italic,.false.)
  CALL j_setfontstyle(label,fontstyle)
END IF

IF(obj == bold) THEN
  IF(j_getstate(bold))  THEN
    fontstyle = fontstyle + j_bold
  ELSE
    fontstyle = fontstyle - j_bold
  END IF
  CALL j_setfontstyle(label,fontstyle)
END IF

IF(obj == italic) THEN
  IF(j_getstate(italic))  THEN
    fontstyle = fontstyle + j_italic
  ELSE
    fontstyle = fontstyle - j_italic
  END IF
  CALL j_setfontstyle(label,fontstyle)
END IF

IF(obj == f10) CALL j_setfontsize(label,10)
IF(obj == f12) CALL j_setfontsize(label,11)
IF(obj == f14) CALL j_setfontsize(label,13)
IF(obj == f18) CALL j_setfontsize(label,18)

WRITE(unit=str,fmt="(a,i3,a,i3,a,i3)") " StringWidth = ",  &
    j_getstringwidth(label,"abcdefghijklmnopqrstuvwxyz"),  &
    " FontHeight = ",j_getfontheight(label),  &
    " FontAscent = ",j_getfontascent(label)
CALL j_settext(frame,str)

END DO NEXTACTION

20      CONTINUE
CALL j_quit()

END PROGRAM JFONT

