PROGRAM JINSETS!       Example insets.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-15  Time: 09:56:11

USE JAPI


INTEGER :: frame,menubar,FILE,insets,obj,canvas
INTEGER :: plus,minus,w,h,quit

IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to JAPI server"
  GO TO 20
END IF

frame     = j_frame("Insets Demo")
CALL j_setborderlayout(frame)

menubar = j_menubar(frame)
FILE    = j_menu(menubar,"File")
insets  = j_menu(menubar,"Insets")
quit    = j_menuitem(FILE,"Quit")
plus    = j_menuitem(insets,"Insets + 10")
minus   = j_menuitem(insets,"Insets - 10")

canvas  = j_canvas(frame,320,240)
CALL j_setnamedcolor(canvas,j_red)

CALL j_pack(frame)
CALL j_show(frame)

NEXTACTION: DO
      obj=j_nextaction()

IF((obj == frame).OR.(obj == quit)) EXIT NEXTACTION

IF(obj == canvas) THEN
  w = j_getwidth(canvas)-1
  h = j_getheight(canvas)-1
  CALL j_drawrect(canvas,0,0,w,h)
  CALL j_drawline(canvas,0,0,w,h)
  CALL j_drawline(canvas,0,h,w,0)
END IF

IF(obj == plus) THEN
  CALL j_setinsets(frame,j_getinsets(frame,j_top)+10,  &
      j_getinsets(frame,j_bottom)+10, j_getinsets(frame,j_left)+10,  &
      j_getinsets(frame,j_right)+10)
END IF

IF(obj == minus) THEN
  CALL j_setinsets(frame,j_getinsets(frame,j_top)-10,  &
      j_getinsets(frame,j_bottom)-10, j_getinsets(frame,j_left)-10,  &
      j_getinsets(frame,j_right)-10)
END IF

END DO NEXTACTION

20      CONTINUE
CALL j_quit()

END PROGRAM JINSETS

