MODULE ITERMAND
public::mandel
CONTAINS

FUNCTION  mandel(zre,zim,maxiter) result (mandel_result)
Integer:: mandel_result
REAL, INTENT(IN)                         :: zre
REAL, INTENT(IN)                         :: zim
INTEGER, INTENT(IN)                      :: maxiter



REAL :: x,y,tmp,betrag
INTEGER :: iter

x=0.0
y=0.0
iter=0
betrag=0.0

MANITER: DO

tmp = x*x-y*y+zre
y = 2*x*y+zim
x = tmp
betrag = x*x + y*y
iter = iter + 1

IF(betrag > 4.0) EXIT MANITER
IF(iter > maxiter)  EXIT MANITER
END DO MANITER
20 continue
mandel_result=iter
END FUNCTION  mandel

END MODULE ITERMAND

PROGRAM JMANDEL!       Example mandel.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-15  Time: 11:02:18

USE JAPI
USE ITERMAND


INTEGER :: breite,hoehe
INTEGER :: x,y,do_work,it
REAL :: zre,zim
REAL :: xstart,ystart,xend,yend

INTEGER :: frame,menubar
INTEGER :: FILE,calc
INTEGER :: quit,start,STOP
INTEGER :: canvas,obj

xstart = -1.8
xend   =  0.8
ystart = -1.0
yend   =  1.0

hoehe  = 240
breite = 320

CALL j_setdebug(-3)

IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to server"
  GO TO 20
END IF

frame   = j_frame("Mandelbrot")
menubar = j_menubar(frame)
FILE    = j_menu(menubar,"File")
calc    = j_menu(menubar,"Calc")
quit    = j_menuitem(FILE,"Quit")
start   = j_menuitem(calc,"Start")
STOP    = j_menuitem(calc,"Stop")

canvas  = j_canvas(frame,breite,hoehe)
CALL j_setpos(canvas,10,60)
CALL j_pack(frame)
CALL j_show(frame)

x=-1
y=-1
do_work=0
NEXTACTION: DO

IF(do_work == 1) THEN
  obj=j_getaction()
ELSE
  obj=j_nextaction()
END IF

IF(obj == quit) EXIT NEXTACTION

IF(obj == start) THEN
  x=-1
  y=-1
  do_work=1
END IF

IF(obj == STOP) do_work=0

IF(do_work == 1) THEN
 ! x=MOD((x+1),breite)
   x=x+1
   if ((x+1) > breite) x=0
   if ((y+1) > hoehe) y=0
   if (x==0) y=y+1
 ! IF(x == 0) y = MOD((y+1),hoehe)
  IF((x == breite-1).AND.(y == hoehe-1)) THEN
  
    do_work=0
  ELSE
    zre = xstart + x*(xend-xstart)/breite
    zim = ystart + y*(yend-ystart)/hoehe
    it = mandel(zre,zim,512)
!                    r=mod(it*11,256)
!                    g=mod(it*13,256)
!                    b=mod(it*17,256)
!                    call j_setcolor(canvas,r,g,b)
    CALL j_setcolor(canvas,it*11,it*13,it*17)
    CALL j_drawpixel(canvas,x,y)
  END IF
END IF

END DO NEXTACTION

20      CONTINUE
CALL j_quit()
END PROGRAM JMANDEL

