MODULE ITERMAND1
public::mandel
CONTAINS
!        Iterationsroutine
FUNCTION  mandel(zre,zim,maxiter) RESULT (MANDEL1)
INTEGER::MANDEL1
REAL, INTENT(IN)                         :: zre
REAL, INTENT(IN)                         :: zim
INTEGER, INTENT(IN)                      :: maxiter



REAL :: x,y,tmp,betrag
INTEGER :: iter

x=0.0
y=0.0
iter=0
betrag=0.0

ITERATE: DO

tmp = x*x-y*y+zre
y = 2*x*y+zim
x = tmp
betrag = x*x + y*y
iter = iter + 1

IF(betrag > 4.0)  EXIT ITERATE
IF(iter > maxiter) EXIT ITERATE
END DO ITERATE

20 CONTINUE
mandel1=iter
END FUNCTION  mandel


END MODULE ITERMAND1

PROGRAM JMANDEL1!       Example mandel1.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-15  Time: 11:29:13

USE JAPI
USE ITERMAND1


INTEGER :: breite,hoehe
INTEGER :: x,y,do_work,it
REAL :: zre,zim
REAL :: xstart,ystart,xend,yend

!       graphical Objects
INTEGER :: frame,menubar
INTEGER :: FILE,calc
INTEGER :: quit,start,STOP
INTEGER :: canvas,obj

!       mandelbrot area
xstart = -1.8
xend   =  0.8
ystart = -1.0
yend   =  1.0

!       window Size
hoehe  = 240
breite = 320


IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to server"
  GO TO 20
END IF


!       Generate Graphical Objects

frame   = j_frame("Mandelbrot")
CALL j_setborderlayout(frame)

menubar = j_menubar(frame)
FILE    = j_menu(menubar,"File")
calc    = j_menu(menubar,"Calc")
quit    = j_menuitem(FILE,"Quit")
start   = j_menuitem(calc,"Start")
STOP    = j_menuitem(calc,"Stop")


canvas  = j_canvas(frame,breite,hoehe)

CALL j_pack(frame)
CALL j_show(frame)

x=-1
y=-1
do_work=0

NEXTACTION: DO 

IF(do_work == 1) THEN
  obj=j_getaction()
ELSE
  obj=j_nextaction()
END IF

IF((obj == quit).OR.(obj == frame))  EXIT NEXTACTION

IF(obj == start) do_work=1

IF(obj == STOP) do_work=0

IF(do_work == 1) THEN
  !x=MOD((x+1),breite)

   x=x+1
   if ((x+1) > breite) x=0
   if ((y+1) > hoehe) y=0
   if (x==0) y=y+1

  !IF(x == 0) y = MOD((y+1),hoehe)
  IF((x == breite-1).AND.(y == hoehe-1)) THEN
    do_work=0
  ELSE
    zre = xstart + x*(xend-xstart)/breite
    zim = ystart + y*(yend-ystart)/hoehe
    it = mandel(zre,zim,512)
    CALL j_setcolor(canvas,it*11,it*13,it*17)
    CALL j_drawpixel(canvas,x,y)
  END IF
END IF

IF(obj == canvas) THEN
  breite = j_getwidth(canvas)
  hoehe  = j_getheight(canvas)
  x = -1
  y = -1
END IF

END DO NEXTACTION

20      CONTINUE
CALL j_quit()

END PROGRAM JMANDEL1





