PROGRAM JMENU!       Example menu.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-15  Time: 11:56:29

USE JAPI

INTEGER :: frame,menubar,submenu
INTEGER :: FILE,edit,options,help
INTEGER :: OPEN,SAVE,quit,about
INTEGER :: cut,copy,paste
INTEGER :: enable,settings
INTEGER :: obj
CHARACTER (LEN=256) :: inhalt

CALL j_setdebug(5)

IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to JAPI Kernel"
  GO TO 20
END IF

frame    = j_frame("Simple")
menubar  = j_menubar(frame)
FILE     = j_menu(menubar,"File")
edit     = j_menu(menubar,"Edit")
options  = j_menu(menubar,"Options")
help     = j_helpmenu(menubar,"Help")
submenu  = j_menu(options,"Settings")

OPEN     = j_menuitem(FILE,"Open")
SAVE     = j_menuitem(FILE,"Save")
CALL j_seperator(FILE)
quit     = j_menuitem(FILE,"Quit")
CALL j_disable(SAVE)
CALL j_setshortcut(quit,"q")

cut      = j_menuitem(edit,"Cut")
copy     = j_menuitem(edit,"Copy")
paste    = j_menuitem(edit,"Paste")

about    = j_menuitem(help,"About")

enable   = j_checkmenuitem(submenu,"Enable Settings")
settings = j_menuitem(submenu,"Settings")
CALL j_disable(settings)

CALL j_show(frame)
NEXTACTION: DO
      obj =  j_nextaction()

IF((obj == frame) .OR. (obj == quit)) EXIT NEXTACTION

IF(obj == enable) THEN
  IF(j_getstate(enable)) THEN
    CALL j_enable(settings)
  ELSE
    CALL j_disable(settings)
  END IF
END IF

IF(obj == cut) THEN
  CALL j_gettext(cut,inhalt)
  IF(inhalt(1:3) == "cut") THEN
    CALL j_settext(cut,"Ausschneiden")
  ELSE
    CALL j_settext(cut,"Cut")
  END IF
END IF

IF(obj == copy) THEN
  CALL j_gettext(copy,inhalt)
  IF(inhalt(1:4) == "copy") THEN
    CALL j_settext(copy,"Kopieren")
  ELSE
    CALL j_settext(copy,"Copy")
  END IF
END IF

IF(obj == paste) THEN
  CALL j_gettext(paste,inhalt)
  IF(inhalt(1:5) == "paste") THEN
    CALL j_settext(paste,"Einfuegen")
  ELSE
    CALL j_settext(paste,"Paste")
  END IF
END IF

END DO NEXTACTION

20  CONTINUE
CALL j_quit()
END PROGRAM JMENU


