PROGRAM JPANEL!       Example panel.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-15  Time: 12:26:25

USE JAPI

INTEGER :: frame,panel,menubar,FILE,doit,quit,label,obj
INTEGER :: p_width,p_height,l_width,l_height
INTEGER :: x,y,dx,dy,run
CHARACTER (LEN=256) :: str

p_width=256
p_height=256
dx=2
dy=1
run=0

IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to JAPI server"
  GO TO 20
END IF

frame   = j_frame("Better Moving Label")
menubar = j_menubar(frame)
FILE    = j_menu(menubar,"File")
doit    = j_menuitem(FILE,"Start")
quit    = j_menuitem(FILE,"Quit")

CALL j_setborderlayout(frame)
panel   = j_panel(frame)

CALL j_show(frame)

label   = j_label(panel,"256:256")
CALL j_setpos(label,120,120)

NEXTACTION: DO 

IF(run == 1) THEN
  obj=j_getaction()
ELSE
  obj=j_nextaction()
END IF

IF((obj == quit) .OR. (obj == frame)) EXIT NEXTACTION

IF(obj == doit) THEN
  IF(run == 0) THEN
    run=1
    CALL j_settext(doit,"Stop")
  ELSE
    run=0
    CALL j_settext(doit,"Start")
  END IF
END IF

IF(obj == panel) THEN
  p_width=j_getwidth(panel)
  p_height=j_getheight(panel)
  WRITE(unit=str,fmt="(i3,a,i3 )")p_width,":",p_height
  CALL j_settext(label,str)
  l_width  = j_getwidth(label)
  l_height = j_getheight(label)
  x=(p_width-l_width)/2
  y=(p_height-l_height)/2
  CALL j_setpos(label,x,y)
END IF

IF(run == 1) THEN
  CALL j_getpos(label,x,y)
  IF((x+l_width  > p_width) .OR. (x < 1)) dx = -dx
  IF((y+l_height > p_height) .OR. (y < 1)) dy = -dy
  CALL j_setpos(label,x+dx, y+dy)
  CALL j_sync()
  CALL j_sleep(10)
END IF

END DO NEXTACTION

20      CONTINUE
CALL j_quit()

END PROGRAM JPANEL



