PROGRAM JTEXT!       Example text.f

! Code converted using TO_F90 by Alan Miller
! Date: 2001-03-15  Time: 15:51:05

USE JAPI 

INTEGER :: frame,menubar,FILE,NEW,SAVE,quit,obj
INTEGER :: edit,selall,cut,copy,paste
INTEGER :: text,selstart,selend
CHARACTER (LEN=256) :: newtext
CHARACTER (LEN=256) :: inhalt

newtext = "JAPI (Java Application"//CHAR(10)//  &
    "Programming Interface)"//CHAR(10)// "a platform and language"//CHAR(10)//  &
    "independent API"

IF( .NOT. j_start()) THEN
  PRINT*, "can't connect to JAPI server"
  GO TO 20
END IF

frame   = j_frame("A simple editor")
menubar = j_menubar(frame)
FILE    = j_menu(menubar,"File")
NEW     = j_menuitem(FILE,"New")
SAVE    = j_menuitem(FILE,"Save")
CALL j_seperator(FILE)
quit    = j_menuitem(FILE,"Quit")


edit    = j_menu(menubar,"Edit")
selall  = j_menuitem(edit,"Select All")
CALL j_seperator(edit)
cut     = j_menuitem(edit,"Cut")
copy    = j_menuitem(edit,"Copy")
paste   = j_menuitem(edit,"Paste")

text    = j_textarea(frame,25,12)
CALL j_setpos(text,10,60)
CALL j_settext(text,newtext)

CALL j_show(frame)
CALL j_pack(frame)
NEXTACTION: DO
      obj =  j_nextaction()
IF((obj == frame) .OR. (obj == quit)) EXIT NEXTACTION

IF(obj == text) PRINT*, "text changed", j_getlength(text)

IF(obj == NEW) CALL j_settext(text,newtext)

IF(obj == SAVE) THEN
  CALL j_gettext(text,inhalt)
  PRINT*, inhalt
END IF

IF(obj == selall) CALL j_selectall(text)

IF((obj == cut).OR.(obj == copy).OR.(obj == paste)) THEN
  selstart=j_getselstart(text)
  selend  =j_getselend(text)
END IF

IF(obj == cut) THEN
  CALL j_delete(text,selstart,selend)
  CALL j_selecttext(text,selstart,selstart)
END IF

IF(obj == copy) CALL j_getseltext(text,inhalt)

IF(obj == paste) THEN
  IF(selstart == selend) THEN
    CALL j_inserttext(text,inhalt,j_getcurpos(text))
  ELSE
    CALL j_replacetext(text,inhalt,selstart,selend)
  END IF
  CALL j_setcurpos(text,selstart)
END IF

END DO NEXTACTION

20  CONTINUE

CALL j_quit()
END PROGRAM JTEXT
