program viewer

use japi

   integer :: frame,canvas,menubar,obj
   integer :: file,open,bmp,ppm,quit
   integer :: image,retval
   logical :: saved
   character (len=256) :: filename

   call j_setdebug(0)

   if(.not. j_start()) then
      print*, "can't connect to JAPI server"
      goto 20
   endif

   frame   = j_frame("Image Viewer")
   menubar = j_menubar(frame)
   file    = j_menu(menubar,"File")
   open    = j_menuitem(file,"Open")
   bmp     = j_menuitem(file,"Save BMM")
   ppm     = j_menuitem(file,"Save PPM")
   call j_seperator(file)
   quit    = j_menuitem(file,"Quit")

   canvas  = j_canvas(frame,320,240)
   call j_setgridlayout(frame,1,1)
   call j_setresizable(frame,J_FALSE)
   call j_disable(bmp)
   call j_disable(ppm)
   call j_pack(frame)
   call j_show(frame)
   filename="images"

   nextaction: do
      obj=j_nextaction()
 
      if((obj == frame) .or. (obj == quit)) exit

      if(obj == open) then
         call j_fileselect(frame,"Open File","*",filename)
         if(len_trim(filename) > 0) then
            image  = j_loadimage(filename)
           if(image == -1) then
               retval = j_alertbox(frame,"Warning","Not a valid image file","Shit")
            else
               call j_setsize(canvas,j_getwidth(image),j_getheight(image))
               call j_pack(frame)
               call j_setnamedcolorbg(canvas,J_WHITE)
               call j_drawimage(canvas,image,0,0)
               call j_enable(bmp)
               call j_enable(ppm)
            endif
         endif
      endif

      if(obj == bmp) then
         call j_fileselect(frame,"Save as BMP","*.bmp",filename)
         if(len(filename) > 1) saved=j_saveimage(image,filename,J_BMP)
      endif

      if(obj == ppm) then
         call j_fileselect(frame,"Save as PPM","*.ppm",filename)
         if(len(filename) > 0) saved=j_saveimage(image,filename,J_PPM)
      endif
      
   enddo nextaction
   

20 continue
   call j_quit()
        
end program viewer


