program windowlistener

use japi

integer:: frame,text,obj
integer:: activated,deactivated,opened,closed,iconfied,deiconfied

call j_setdebug(3)

if( .not. j_start()) then
    PRINT*, "can't connect to JAPI server"   
    go to 20
end if

frame       = j_frame("Window Listener")
call j_setgridlayout(frame,1,1)

text        = j_textarea(frame,80,25)

opened      = j_windowlistener(frame,J_OPENED)
closed      = j_windowlistener(frame,J_CLOSED)
activated   = j_windowlistener(frame,J_ACTIVATED)
deactivated = j_windowlistener(frame,J_DEACTIVATED)
iconfied    = j_windowlistener(frame,J_ICONIFIED)
deiconfied  = j_windowlistener(frame,J_DEICONIFIED)

call j_show(frame)
call j_pack(frame)

obj = 0
nextaction: do
    obj=j_getaction()
    
    if(obj == frame) exit nextaction
 
    if(obj == opened) call j_appendtext(text,"Frame opened"//char(10))
 		
    if(obj == closed) call j_appendtext(text,"Frame closed"//char(10))

    if(obj == activated) call j_appendtext(text,"Frame activated"//char(10))

    if(obj == deactivated) call j_appendtext(text,"Frame deactivated"//char(10))

    if(obj == iconfied) call j_appendtext(text,"Frame iconfied"//char(10))

    if(obj == deiconfied) call j_appendtext(text,"Frame deiconfied"//char(10))

end do nextaction

call j_appendtext(text,"Frame closing, press again"//char(10))

disposeframe: do  
    obj=j_nextaction()
    if (obj == frame) exit disposeframe
end do disposeframe
call j_dispose(frame)

closeframe: do
    obj=j_nextaction()
    if (obj == closed) exit closeframe
end do closeframe
print*, "Frame closed"

20 continue

call j_quit()

end program windowlistener


