import java.awt.*;

public class JAPI_Dialog extends Dialog
{
	Insets inset;
	boolean resizable=true;

	public JAPI_Dialog(Frame parent,String title)
	{
		super(parent,title,false);
		addNotify();   // WICHTIG (win32 jdk1.1) !!!!
		this.setLayout(new JAPI_Fixlayout());
	}

	public void setResizable(boolean set)
	{
		resizable=set;
		repaint(-1);
	}

	public void paint(Graphics g)
	{
	    if(isResizable()!=resizable)
	    	super.setResizable(resizable);
	}

	public void disable()
	{
		for(int i=0;i<getComponentCount();i++)
			getComponent(i).disable();
	}

	public void enable()
	{
 		for(int i=0;i<getComponentCount();i++)
			getComponent(i).enable();
	}

	public void setInsets(int t, int b, int l, int r)
	{
		inset = new Insets(t,l,b,r);
	}

	public Insets getInsets()
	{
		if(inset != null)
			return(inset);
		else
			return(super.getInsets());
	}

    public void setFont(Font f)
    {
   		super.setFont(f);
		for(int i=0;i<getComponentCount();i++)
			if(getComponent(i).getPeer() != null)
				getComponent(i).setFont(f);
    }

    public void setBackground(Color c)
    {
    	super.setBackground(c);
 		for(int i=0;i<getComponentCount();i++)
			getComponent(i).setBackground(c);
    }

}
