import java.awt.*;
//import javax.swing.*;
import java.io.*;

public class JAPI_Frame extends Frame
{
	Insets inset;
	boolean resizable=true;

	public JAPI_Frame(String title)
	{
		super(title);
		addNotify();   // WICHTIG !!!!
		super.setLayout(new JAPI_Fixlayout());
	}

	public void setResizable(boolean set)
	{
		resizable=set;
		repaint(-1);
	}

	public void paint(Graphics g)
	{
	    if(isResizable()!=resizable)
	    	super.setResizable(resizable);
	}

	public void disable()
	{
		int i;
		for(i=0;i<getComponentCount();i++)
			getComponent(i).disable();
		if(getMenuBar() != null)
			((JAPI_Menubar)getMenuBar()).disable();
	}

	public void enable()
	{
		int i;
 		for(i=0;i<getComponentCount();i++)
			getComponent(i).enable();
		if(getMenuBar() != null)
			((JAPI_Menubar)getMenuBar()).enable();
	}

	public void setInsets(int t, int b, int l, int r)
	{
		inset = new Insets(t,l,b,r);
	}

	public Insets getInsets()
	{
		if(inset != null)
			return(inset);
		else
			return(super.getInsets());
	}

    public void setBackground(Color c)
    {
    	super.setBackground(c);
		int i;
 		for(i=0;i<getComponentCount();i++)
			getComponent(i).setBackground(c);
		// menus haben keine Funktionen zum Setzen der Farben
    }

    public void setFont(Font f)
    {
		int i;
   		super.setFont(f);
		for(i=0;i<getComponentCount();i++)
			if(getComponent(i).getPeer() != null)
				getComponent(i).setFont(f);
		if(getMenuBar() != null)
			((JAPI_Menubar)getMenuBar()).setFont(f);
   }
}
