import java.awt.*;
import java.net.*;

public class JAPI_Graphiclabel extends Label
{
  	Image picture=null;
 	private Dimension prefSize = new Dimension(0,0);

  	public JAPI_Graphiclabel(String filename, String host, int port)
  	throws MalformedURLException
  	{
        picture = Toolkit.getDefaultToolkit().getImage(new URL("http",host,port,filename));
    	MediaTracker tracker = new MediaTracker(this);
    	tracker.addImage(picture, 0);
 		try {tracker.waitForAll();} catch(InterruptedException e) {}
 		this.setSize(picture.getWidth(this), picture.getHeight(this));
	}

  	// used by JAPI_Alert, JAPI_Error
  	public JAPI_Graphiclabel(String filename)
  	{
        picture = Toolkit.getDefaultToolkit().getImage(getClass().getResource(filename));
     	MediaTracker tracker = new MediaTracker(this);
    	tracker.addImage(picture, 0);
    	try {tracker.waitForID(0);} catch(InterruptedException e) {System.err.println("Error: "+e);}
   		this.setSize(picture.getWidth(this), picture.getHeight(this));
    }

	public void setImage(Image img)
	{
		picture=img;
        paint(getGraphics());
	}

	public void setSize(int width, int height)
	{
    	prefSize = new Dimension(width, height);
 		super.setSize(prefSize.width, prefSize.height);
	}

	public Dimension getPreferredSize()
	{
    	return prefSize;
  	}

  	public Dimension getMinimumSize()
  	{
    	return prefSize;
  	}

  	public void paint(Graphics g)
	{
		// Einmal sollte genuegen, tut es aber manchmal nicht !
		if(isVisible())
		{
			g.drawImage(picture, 0, 0, prefSize.width, prefSize.height, this);
			g.drawImage(picture, 0, 0, prefSize.width, prefSize.height, this);
  		}
	}


}