import java.awt.*;

public class JAPI_Progressbar extends JAPI_ValueComponent
{
	private int orient;
	 public JAPI_Progressbar(int o)
    {
        setFont(new Font("Dialog", Font.PLAIN, 12));
		super.setSize(100,20);
		orient=o;
		setForeground(Color.blue);
	//	setBackground(Color.lightGray);
	}

    public void setValue(int v)
    {
		super.setValue(v);
    	repaint();
    }

   	public void paint(Graphics g)
    {
		Dimension d = super.size();
		int val;

		g.setColor(Color.gray);
		g.draw3DRect(0,0,d.width-1,d.height-1,false);

 		if(orient==0)
			val=(d.width-4)*(value-min)/(max-min);
		else
			val=(d.height-4)*(value-min)/(max-min);

		g.setColor(getForeground());
		if(orient==0)
	    	g.fillRect(2,2,val,d.height-4);
	    else
	    	g.fillRect(2,d.height-val,d.width-4,val-2);

 		g.setColor(getBackground());
	    g.drawString(Integer.toString(value),
    		d.width/2-g.getFontMetrics(g.getFont()).stringWidth(Integer.toString(value))/2,
    		d.height/2+g.getFontMetrics(g.getFont()).getHeight()/2-1);

		if(orient==0)
	    	g.fillRect(val,2,d.width-4,d.height-4);
    	else
    		g.fillRect(2,2,d.width-4,d.height-2-val);

 		g.setColor(getForeground());
		if(orient==0)
		    g.clipRect(val,0,d.width,d.height);
		else
			g.clipRect(0,0,d.width,d.height-val);
			g.drawString(Integer.toString(value),
    		d.width/2 -g.getFontMetrics(g.getFont()).stringWidth(Integer.toString(value))/2,
    		d.height/2+g.getFontMetrics(g.getFont()).getAscent()/2-1);

//		g.clipRect(0,0,d.width,d.height);
  	}



    public void update(Graphics g)
    {
        paint(g);
    }
}
