import java.awt.*;

public class JAPI_Ruler extends Canvas
{

	int w=0,h=0,orient=JAPI_Const.J_HORIZONTAL,style=JAPI_Const.J_LINEUP;

	public JAPI_Ruler (int o, int s, int len)
	{
		super();
		orient=o;
		style=s;
		if(orient==JAPI_Const.J_HORIZONTAL)
			setSize(len,4);
		else
			setSize(4,len);
	}

	public void setBounds( int x, int y, int dw, int dh)
	{
		w = dw>0 ? dw : 0;
		h = dh>0 ? dh : 0;
		super.setBounds(x,y,dw,dh);
	}

	public void setSize( int dw, int dh)
	{
		w = dw>0 ? dw : 0;
		h = dh>0 ? dh : 0;
		super.setSize(dw,dh);
	}

	public Dimension preferredSize()
	{
		Dimension dim = super.preferredSize();
		dim.width  = w>0 ? w : dim.width;
		dim.height = h>0 ? h : dim.height;
		return(dim);
	}

	public Dimension minimumSize()
	{
		Dimension dim = super.minimumSize();
		dim.width  = w>0 ? w : dim.width;
		dim.height = h>0 ? h : dim.height;
		return(dim);
	}

    public void paint(Graphics g)
    {
		if(orient==JAPI_Const.J_HORIZONTAL)
		{
			if(style==JAPI_Const.J_LINEUP)
			{
				g.setColor(Color.white);
	 			g.drawLine(0,h/2-1,w,h/2-1);
				g.setColor(Color.darkGray);
	 			g.drawLine(0,h/2,w,h/2);
			}
			else
			{
				g.setColor(Color.darkGray);
	 			g.drawLine(0,h/2-1,w,h/2-1);
				g.setColor(Color.white);
	 			g.drawLine(0,h/2,w,h/2);
			}
		}
		else  //J_VERTICAL
		{
			if(style==JAPI_Const.J_LINEUP)
			{
				g.setColor(Color.white);
	 			g.drawLine(w/2-1,0,w/2-1,h);
				g.setColor(Color.darkGray);
	 			g.drawLine(w/2,0,w/2,h);
			}
			else
			{
				g.setColor(Color.darkGray);
	 			g.drawLine(w/2-1,0,w/2-1,h);
				g.setColor(Color.white);
	 			g.drawLine(w/2,0,w/2,h);
			}
		}
	}
}