import java.awt.*;

public class JAPI_Textarea extends TextArea
{

	int w=0,h=0;

	public JAPI_Textarea(int r, int c)
	{
		super(r,c);
	}

	public void setSize(int dw, int dh)
	{
		w = dw>0 ? dw : 0;
		h = dh>0 ? dh : 0;
		super.setSize(w,h);
	}

	public void setRows(int r)
	{
		if((h=getPreferredSize(r,1).height)>0)
			super.setSize(w,h);
	}

	public int getRows()
	{
		int r=0;
		while(getPreferredSize(r,1).height < getSize().height)
			r++;
		return(--r);
	}

	public void setColumns(int c)
	{
		if((w=getPreferredSize(1,c).width)>0)
			super.setSize(w,h);
	}

	public int getColumns()
	{
		int c=0;
		while(getPreferredSize(1,c).width < getSize().width)
			c++;
		return(--c);
	}


	public Dimension preferredSize()
	{
		Dimension dim = super.preferredSize();
		dim.width  = w>0 ? w : dim.width;
		dim.height = h>0 ? h : dim.height;
		return(dim);
	}

	public Dimension minimumSize()
	{
		Dimension dim = super.minimumSize();
		dim.width  = w>0 ? w : dim.width;
		dim.height = h>0 ? h : dim.height;
		return(dim);
	}

}